/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.pitch;

import java.util.Arrays;
import org.corebounce.common.math.Cmplx;
import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.bouncelets.audio.base.SpectrumData;
import org.corebounce.decklight.bouncelets.audio.base.WindowInfo;
import org.corebounce.decklight.bouncelets.audio.ports.InSpectrum;
import org.corebounce.decklight.bouncelets.audio.ports.OutSpectrum;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InBoolean;
import org.corebounce.decklight.ports.InInt;

public class PitchShiftOctave
extends Bouncelet {
    public InSpectrum inSpectrum = new InSpectrum("in", "Input audio spectrum");
    public InInt inRatio = new InInt("ratio", "Pitch Shift ratio", 2, 2, 8);
    public InBoolean inApprox = new InBoolean("approx", "Use fast approximations", true);
    public OutSpectrum outSpectrum = new OutSpectrum("out", "Output audio spectrum");
    private Cmplx[][] source;
    private float[][] outAngles;
    private int ratio;

    public PitchShiftOctave() {
        super("audio.effect.spectrum.pitch.pitchshift-octave", "Raise the pitch by one octave");
        super.setSkillType(SkillType.ADVANCED);
        this.inApprox.setSkillType(SkillType.NORMAL);
        this.inRatio.setSkillType(SkillType.EXPERT);
    }

    public void cycle() {
        this.setup();
        this.process();
    }

    private void setup() {
        SpectrumData inData = (SpectrumData)this.inSpectrum.peek();
        boolean changes = this.outSpectrum.prepare(inData, null);
        SpectrumData outData = (SpectrumData)this.outSpectrum.get();
        if (changes |= inData.windowing.isWindowModified()) {
            float[] srcWindow = inData.windowing.getWindow();
            float[] dstWindow = new float[inData.getNbFrames()];
            float energy = 0.0f;
            int i = 0;
            while (i < srcWindow.length) {
                energy += srcWindow[i] * srcWindow[i];
                ++i;
            }
            float value = (float)Math.sqrt(energy * 2.0f / (float)srcWindow.length);
            Arrays.fill(dstWindow, value);
            outData.windowing = new WindowInfo(dstWindow, inData.windowing.getOverlapping());
            outData.windowing.setWindowModified(true);
            if (inData.nbLayers > 1) {
                this.source = Cmplx.newArray(inData.audioChannels(), inData.nbBins);
                this.outAngles = new float[inData.audioChannels()][inData.nbBins / 2];
            } else {
                this.source = null;
                this.outAngles = null;
            }
        } else {
            outData.windowing.setWindowModified(false);
        }
        if (this.inRatio.isModified()) {
            this.ratio = (Integer)this.inRatio.read();
        }
    }

    private void process() {
        SpectrumData inData = (SpectrumData)this.inSpectrum.read();
        SpectrumData outData = (SpectrumData)this.outSpectrum.get();
        boolean approx = (Boolean)this.inApprox.read();
        if (inData.nbLayers > 1) {
            this.processMultiLayers(inData, outData, approx);
        } else {
            this.processSingleLayer(inData, outData, approx);
        }
    }

    private void processMultiLayers(SpectrumData inData, SpectrumData outData, boolean approx) {
        inData.fillSumByLayer(this.source);
        int aChan = 0;
        while (aChan < inData.audioChannels()) {
            float[] outAngles = this.outAngles[aChan];
            Cmplx[] source = this.source[aChan];
            int i = 1;
            while (i < source.length / 2) {
                float outAngle;
                float inAngle = source[i].phi();
                outAngles[i] = outAngle = (float)this.ratio * inAngle;
                ++i;
            }
            ++aChan;
        }
        int chan = 0;
        while (chan < inData.nbChannels) {
            int k;
            float magnitude;
            int i;
            int srcIndex = chan / inData.nbLayers;
            Cmplx[] input = inData.data[chan];
            Cmplx[] output = outData.data[chan];
            float[] chanOutAngles = this.outAngles[srcIndex];
            if (approx) {
                i = 1;
                while (i < input.length / this.ratio) {
                    magnitude = input[i].magApprox();
                    output[i * this.ratio].set(magnitude, chanOutAngles[i]);
                    output[i * this.ratio].toCartesianApprox();
                    k = 1;
                    while (k < this.ratio) {
                        output[i * this.ratio + k].clear();
                        ++k;
                    }
                    ++i;
                }
            } else {
                i = 1;
                while (i < input.length / this.ratio) {
                    magnitude = input[i].mag();
                    output[i * this.ratio].set(magnitude, chanOutAngles[i]);
                    output[i * this.ratio].toCartesian();
                    k = 1;
                    while (k < this.ratio) {
                        output[i * this.ratio + k].clear();
                        ++k;
                    }
                    ++i;
                }
            }
            output[0].set(input[0]);
            output[output.length - 1].clear();
            ++chan;
        }
    }

    private void processSingleLayer(SpectrumData inData, SpectrumData outData, boolean approx) {
        int chan = 0;
        while (chan < inData.nbChannels) {
            int k;
            float mag;
            float angle;
            float magnitude;
            Cmplx out;
            Cmplx in;
            int i;
            Cmplx[] input = inData.data[chan];
            Cmplx[] output = outData.data[chan];
            if (approx) {
                if (this.ratio == 2) {
                    i = 1;
                    while (i < input.length / 2) {
                        in = input[i];
                        out = output[i * 2];
                        out.prod(in, in);
                        magnitude = in.magApprox();
                        if (magnitude > 0.0f) {
                            out.mul(1.0f / magnitude);
                        }
                        output[i * 2 + 1].clear();
                        ++i;
                    }
                } else {
                    i = 1;
                    while (i < input.length / this.ratio) {
                        in = input[i];
                        out = output[i * this.ratio];
                        angle = in.phi() * (float)this.ratio;
                        mag = in.magApprox();
                        out.set(mag, angle);
                        out.toCartesianApprox();
                        k = 1;
                        while (k < this.ratio) {
                            output[i * this.ratio + k].clear();
                            ++k;
                        }
                        ++i;
                    }
                }
            } else if (this.ratio == 2) {
                i = 1;
                while (i < input.length / 2) {
                    in = input[i];
                    out = output[i * 2];
                    out.prod(in, in);
                    magnitude = in.mag();
                    if (magnitude > 0.0f) {
                        out.mul(1.0f / magnitude);
                    }
                    output[i * 2 + 1].clear();
                    ++i;
                }
            } else {
                i = 1;
                while (i < input.length / this.ratio) {
                    in = input[i];
                    out = output[i * this.ratio];
                    angle = in.phi() * (float)this.ratio;
                    mag = in.mag();
                    out.set(mag, angle);
                    out.toCartesian();
                    k = 1;
                    while (k < this.ratio) {
                        output[i * this.ratio + k].clear();
                        ++k;
                    }
                    ++i;
                }
            }
            output[0].set(input[0]);
            output[output.length - 1].clear();
            ++chan;
        }
    }
}

