/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.pitch;

import org.corebounce.decklight.BounceletBase;
import org.corebounce.decklight.bouncelets.audio.base.PowerOf2;
import org.corebounce.decklight.bouncelets.audio.convert.format.SpectrumToWave;
import org.corebounce.decklight.bouncelets.audio.convert.format.WaveToSpectrum;
import org.corebounce.decklight.bouncelets.audio.effect.spectrum.pitch.ChipMunk;
import org.corebounce.decklight.bouncelets.audio.effect.spectrum.pitch.PitchShiftOcean;
import org.corebounce.decklight.bouncelets.audio.effect.wave.stereo.Screw;
import org.corebounce.decklight.bouncelets.signal.Div;
import org.corebounce.decklight.bouncelets.signal.values.Double;
import org.corebounce.decklight.bridge.ScaleType;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.macro.Connector;
import org.corebounce.decklight.macro.MacroBouncelet;
import org.corebounce.decklight.ports.InputPort;
import org.corebounce.decklight.ports.OutputPort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PitchShiftVoice
extends MacroBouncelet {
    private final Screw screwIn = new Screw();
    private final Double ratio = new Double("ratio", "Pitch shifting ratio", 1.0, 0.5, 2.0);
    private final Div inv = new Div();
    private final WaveToSpectrum wave2spectrum1 = new WaveToSpectrum();
    private final PitchShiftOcean pitchShift = new PitchShiftOcean();
    private final ChipMunk chipMunk = new ChipMunk();
    private final SpectrumToWave spectrum2wave2 = new SpectrumToWave();
    private final Screw screwOut = new Screw();
    private final BounceletBase[] parts = new BounceletBase[]{this.screwIn, this.ratio, this.inv, this.wave2spectrum1, this.pitchShift, this.chipMunk, this.spectrum2wave2, this.screwOut};

    public PitchShiftVoice() {
        super("audio.effect.fourier.pitch.pitchshift-voice", "Pitch shifting with formants preserving");
        super.setSkillType(SkillType.SIMPLIFIED);
        this.ratio.inDouble.setScaleType(ScaleType.LOG2);
    }

    @Override
    public void createInternalConnections(Connector connector) {
        connector.connect(this.screwIn.outAudio, this.wave2spectrum1.inAudio());
        connector.connect(this.wave2spectrum1.outSpectrum(), this.chipMunk.getInSpectrum());
        connector.connect(this.chipMunk.getOutSpectrum(), this.pitchShift.inSpectrum);
        connector.connect(this.pitchShift.outSpectrum, this.spectrum2wave2.inSpectrum());
        connector.connect(this.spectrum2wave2.outAudio(), this.screwOut.inAudio);
        connector.connect(this.ratio.outDouble, this.pitchShift.inRatio);
        this.inv.inValue1.write(1.0);
        connector.connect(this.ratio.outDouble, this.inv.inValue2);
        connector.connect(this.inv.outResult, this.chipMunk.getInRatio());
        this.pitchShift.inPreset.write(PitchShiftOcean.Preset.Normal);
        this.wave2spectrum1.inOverlap().write(PowerOf2.p8);
        super.createDeepInternalConnections(connector, this.parts);
    }

    @Override
    protected InputPort<?>[] getMacroInputPorts() {
        return new InputPort[]{this.screwIn.inAudio, this.ratio.inDouble};
    }

    @Override
    protected OutputPort<?>[] getMacroOutputPorts() {
        return new OutputPort[]{this.screwOut.outAudio};
    }

    @Override
    public BounceletBase[] getParts() {
        return super.getDeepParts(this.parts);
    }
}

