/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.shape;

import java.util.Arrays;
import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.bouncelets.audio.base.AudioConfig;
import org.corebounce.decklight.bouncelets.audio.base.FrequenciesData;
import org.corebounce.decklight.bouncelets.audio.ports.InFrequencies;
import org.corebounce.decklight.bouncelets.audio.ports.OutFrequencies;
import org.corebounce.decklight.bridge.ScaleType;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;

public class ShapeShifter
extends Bouncelet {
    public InFrequencies inFreqs = new InFrequencies("in", "Input frequencies");
    public InDouble inShiftRatio = new InDouble("shift", "Frequency scaling ratio", 1.0, 0.25, 4.0);
    public InDouble inDetune = new InDouble("detune", "Frequency shifting amount", 0.0, -11000.0, 11000.0);
    public OutFrequencies outFreqs = new OutFrequencies("out", "Output frequencies");
    private double shiftRatio;
    private int detune;

    public ShapeShifter() {
        super("audio.effect.spectrum.shape.shape-shifter", "Shift/detune formants");
        super.setSkillType(SkillType.ADVANCED);
        this.inShiftRatio.setSkillType(SkillType.SIMPLIFIED);
        this.inDetune.setSkillType(SkillType.ADVANCED);
        this.inShiftRatio.setScaleType(ScaleType.LOG2);
        this.inDetune.setScaleType(ScaleType.CUBEROOT);
    }

    public void cycle() {
        this.setup();
        this.process();
    }

    private void setup() {
        FrequenciesData freqs = (FrequenciesData)this.inFreqs.peek();
        this.outFreqs.prepare(freqs.nbChannels, freqs.nbBins);
        if (this.inShiftRatio.isModified()) {
            this.shiftRatio = (Double)this.inShiftRatio.read();
        }
        if (this.inDetune.isModified()) {
            double amount = (Double)this.inDetune.read();
            this.detune = (int)(amount * (double)freqs.getNbFrames() / (double)AudioConfig.getSampleRate() + 0.5);
            if (this.detune > freqs.nbBins) {
                this.detune = freqs.nbBins;
            } else if (this.detune < -freqs.nbBins) {
                this.detune = -freqs.nbBins;
            }
        }
    }

    private void process() {
        FrequenciesData inCurve = (FrequenciesData)this.inFreqs.read();
        FrequenciesData outCurve = (FrequenciesData)this.outFreqs.get();
        int chan = 0;
        while (chan < inCurve.nbChannels) {
            float[] input = inCurve.data[chan];
            float[] output = outCurve.data[chan];
            this.shift(input, output);
            this.detune(output);
            ++chan;
        }
    }

    private void shift(float[] input, float[] output) {
        int nq = input.length - 1;
        output[0] = input[0];
        output[nq] = 0.0f;
        int i = 1;
        while (i < nq) {
            double src = (double)i / this.shiftRatio;
            int src0 = (int)src;
            int src1 = src0 + 1;
            float w1 = (float)src - (float)src0;
            float w0 = 1.0f - w1;
            float smp0 = 0.0f;
            if (src0 > 0 && src0 < nq) {
                smp0 = input[src0];
            }
            float smp1 = 0.0f;
            if (src1 > 0 && src1 < nq) {
                smp1 = input[src1];
            }
            output[i] = smp0 * w0 + smp1 * w1;
            ++i;
        }
    }

    private void detune(float[] output) {
        if (this.detune < 0) {
            System.arraycopy(output, -this.detune, output, 0, output.length + this.detune);
            Arrays.fill(output, output.length + this.detune, output.length, 0.0f);
        } else if (this.detune > 0) {
            System.arraycopy(output, 0, output, this.detune, output.length - this.detune);
            Arrays.fill(output, 0, this.detune, 0.0f);
        }
    }
}

