/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.shape;

import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.bouncelets.audio.base.AudioConfig;
import org.corebounce.decklight.bouncelets.audio.base.FrequenciesData;
import org.corebounce.decklight.bouncelets.audio.effect.spectrum.shape.ShapeSmoothEngine;
import org.corebounce.decklight.bouncelets.audio.ports.InFrequencies;
import org.corebounce.decklight.bouncelets.audio.ports.OutFrequencies;
import org.corebounce.decklight.bridge.ScaleType;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;

public class ShapeSmooth
extends Bouncelet {
    public InFrequencies inFreqs = new InFrequencies("in", "Source shape");
    public InDouble inDuration = new InDouble("duration", "Smoothing duration [s]", 1.0, 0.01, 10.0);
    public OutFrequencies outFreqs = new OutFrequencies("out", "Smoothed shape");
    private int nbBins = 0;
    private ShapeSmoothEngine[] engines;

    public ShapeSmooth() {
        super("audio.effect.spectrum.shape.shape-smooth", "Smooth (average) the shape over time");
        super.setSkillType(SkillType.ADVANCED);
        this.inDuration.setScaleType(ScaleType.LOG2);
    }

    public void cycle() {
        this.setup();
        this.process();
    }

    private int getLength(FrequenciesData data) {
        double frameDuration;
        double duration = (Double)this.inDuration.read();
        int length = (int)(duration / (frameDuration = (double)data.getNbFrames() / (double)AudioConfig.getSampleRate() / 4.0) + 0.5);
        if (length <= 0) {
            length = 1;
        }
        return length;
    }

    private void setup() {
        block3: {
            FrequenciesData data;
            block2: {
                data = (FrequenciesData)this.inFreqs.peek();
                if (this.engines != null && this.engines.length == data.nbChannels && data.nbBins == this.nbBins) break block2;
                this.nbBins = data.nbBins;
                this.engines = new ShapeSmoothEngine[data.nbChannels];
                int length = this.getLength(data);
                int i = 0;
                while (i < data.nbChannels) {
                    this.engines[i] = new ShapeSmoothEngine(data.nbBins, length);
                    ++i;
                }
                break block3;
            }
            if (!this.inDuration.isModified()) break block3;
            int length = this.getLength(data);
            int i = 0;
            while (i < this.engines.length) {
                this.engines[i].setSize(length);
                ++i;
            }
        }
    }

    private void process() {
        FrequenciesData inData = (FrequenciesData)this.inFreqs.read();
        this.outFreqs.prepare(inData.nbChannels, inData.nbBins);
        FrequenciesData outData = (FrequenciesData)this.outFreqs.get();
        int chan = 0;
        while (chan < inData.nbChannels) {
            this.engines[chan].push(inData.data[chan], outData.data[chan]);
            ++chan;
        }
    }
}

