/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.time;

import org.corebounce.decklight.bouncelets.audio.base.AudioStateWaveBouncelet;
import org.corebounce.decklight.bouncelets.audio.base.PowerOf2;
import org.corebounce.decklight.bouncelets.audio.effect.spectrum.time.CurvedDelayEngine;
import org.corebounce.decklight.bouncelets.audio.ports.InAudio;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;
import org.corebounce.decklight.bridge.ScaleType;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;
import org.corebounce.decklight.ports.InInt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CurvedDelayBase
extends AudioStateWaveBouncelet<CurvedDelayEngine> {
    public static final PowerOf2 WINDOW_SIZE = PowerOf2.p1024;
    public static final PowerOf2 SHIFT_SIZE = PowerOf2.p512;
    public InAudio inAudio = new InAudio("in", "Input audio wave");
    public InDouble inDelay = new InDouble("delay", "delay(high) - delay(low) [s]", 0.1, -1.0, 1.0);
    public InInt inNumBands = new InInt("bands", "Number of frequency bands", 32, 4, 128);
    public OutAudio outAudio = new OutAudio("out", "Output audio wave");

    public CurvedDelayBase() {
        super("audio.effect.fourier.time.curved-delay", "(Internal)");
        this.inDelay.setSkillType(SkillType.SIMPLIFIED);
        this.inDelay.setScaleType(ScaleType.CUBEROOT);
        this.inNumBands.setSkillType(SkillType.ADVANCED);
    }

    @Override
    public boolean checkForChanges() {
        return this.inNumBands.isModified();
    }

    protected CurvedDelayEngine[] createStates(int nbChans) {
        CurvedDelayEngine[] result = new CurvedDelayEngine[nbChans];
        double delay = (Double)this.inDelay.read();
        int i = 0;
        while (i < nbChans) {
            result[i] = new CurvedDelayEngine(WINDOW_SIZE, (Integer)this.inNumBands.read());
            result[i].setDelay(delay);
            ++i;
        }
        return result;
    }

    @Override
    public void setup(boolean changes) {
        if (!changes && this.inDelay.isModified()) {
            double delay = (Double)this.inDelay.read();
            CurvedDelayEngine[] curvedDelayEngineArray = (CurvedDelayEngine[])this.states;
            int n = curvedDelayEngineArray.length;
            int n2 = 0;
            while (n2 < n) {
                CurvedDelayEngine engine = curvedDelayEngineArray[n2];
                engine.setDelay(delay);
                ++n2;
            }
        }
        super.setup(changes);
    }

    @Override
    public void process(CurvedDelayEngine state, float[] input, float[] output) {
        state.process(input, output);
    }
}

