/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.time;

import java.util.Arrays;
import java.util.BitSet;
import org.corebounce.common.math.Cmplx;
import org.corebounce.decklight.bouncelets.audio.base.AudioMath;
import org.corebounce.decklight.bouncelets.audio.effect.spectrum.time.BeatExtractEngine;

public class EdgeExtractor {
    private static final float CEIL_LEVEL = 10.0f;
    private static final float FLOOR_LEVEL = (float)AudioMath.dbToLevel(-120.0);
    private static final float MAX_SKEW = (float)AudioMath.dbToLevel(20.0);
    private final int nbChans;
    private final int nbBins;
    private final float sensitivity;
    private final int attackDelay;
    private final double attackSpeed;
    private final int minSpan;
    private final int spread;
    private final boolean hard;
    private final float maxJump;
    private final float floorLevel;
    private final float[][] levels;
    private final float[] commonLevels;
    private final Cmplx[] source;
    private final BeatExtractEngine[] engines;
    private final BitSet attacks;
    private final float[][] edgeRatio;
    private final float[][] startLevels;
    private final int[] commonAttackTimes;
    private final float[] commonAttackLevels;

    public EdgeExtractor(int nbChans, int nbBins, int minimizerLength, int averagerLength, double sensitivity, int attackDelay, double attackSpeed, int minSpan, int spread, boolean hard, boolean splitMode, float maxJump) {
        this.nbChans = nbChans;
        this.nbBins = nbBins;
        this.sensitivity = (float)AudioMath.dbToLevel(sensitivity);
        this.attackDelay = attackDelay;
        this.attackSpeed = AudioMath.dbToLevel(attackSpeed);
        this.minSpan = minSpan;
        this.spread = spread;
        this.hard = hard;
        this.maxJump = maxJump;
        this.floorLevel = (float)AudioMath.dbToLevel(-100.0) * (float)sensitivity;
        if (splitMode) {
            this.levels = new float[nbChans][nbBins];
            this.source = null;
        } else {
            this.levels = null;
            this.source = Cmplx.newArray(nbBins);
        }
        this.commonLevels = new float[nbBins];
        int nbEngines = splitMode ? nbChans : 1;
        this.engines = new BeatExtractEngine[nbEngines];
        int i = 0;
        while (i < nbEngines) {
            this.engines[i] = new BeatExtractEngine(nbBins, minimizerLength, averagerLength);
            ++i;
        }
        this.attacks = new BitSet(nbBins);
        this.edgeRatio = new float[nbChans][nbBins];
        this.startLevels = new float[nbEngines][nbBins];
        int c = 0;
        while (c < nbEngines) {
            Arrays.fill(this.startLevels[c], (float)AudioMath.dbToLevel(-100.0));
            ++c;
        }
        this.commonAttackTimes = new int[nbBins];
        this.commonAttackLevels = new float[nbBins];
        Arrays.fill(this.commonAttackLevels, (float)AudioMath.dbToLevel(-100.0));
    }

    public int getNbChans() {
        return this.nbChans;
    }

    public int getNbBins() {
        return this.nbBins;
    }

    public void analyzeMixed(Cmplx[][] channels) {
        if (channels.length != this.nbChans) {
            throw new IllegalArgumentException("Illegal number of channels");
        }
        this.attacks.clear();
        this.fillSum(channels);
        this.computeLevels(this.source, this.commonLevels);
        this.analyzeAttacks(this.engines[0], this.commonLevels);
        this.updateAttacks(this.attackSpeed);
        this.applyMinSpan();
        this.applySpread();
        this.fillStartLevels(this.startLevels[0], this.engines[0], this.hard);
        this.processAttacksMixed();
        this.engines[0].push(this.source);
    }

    public void analyseSplitted(Cmplx[][] channels) {
        if (channels.length != this.nbChans) {
            throw new IllegalArgumentException("Illegal number of channels");
        }
        this.attacks.clear();
        int c = 0;
        while (c < this.nbChans) {
            if (channels[c].length != this.nbBins) {
                throw new IllegalArgumentException("Illegal number of bins for channel " + c);
            }
            this.computeLevels(channels[c], this.levels[c]);
            this.analyzeAttacks(this.engines[c], this.levels[c]);
            ++c;
        }
        this.updateAttacks(this.attackSpeed);
        this.computeCommonlevels();
        this.applyMinSpan();
        this.applySpread();
        c = 0;
        while (c < this.nbChans) {
            this.fillStartLevels(this.startLevels[c], this.engines[c], this.hard);
            ++c;
        }
        this.processAttacksSplitted();
    }

    public void analyseMonitored(Cmplx[][] channels, Cmplx[][] monitor) {
        if (channels.length != this.nbChans) {
            throw new IllegalArgumentException("Illegal number of channels");
        }
        this.attacks.clear();
        int c = 0;
        while (c < this.nbChans) {
            if (channels[c].length != this.nbBins) {
                throw new IllegalArgumentException("Illegal number of bins for channel " + c);
            }
            this.computeLevels(monitor[c], this.commonLevels);
            this.computeLevels(channels[c], this.levels[c]);
            this.analyzeAttacksMonitored(this.engines[c], this.levels[c], this.commonLevels);
            ++c;
        }
        this.updateAttacks(this.attackSpeed);
        this.computeCommonlevels();
        this.applyMinSpan();
        this.applySpread();
        c = 0;
        while (c < this.nbChans) {
            this.fillStartLevels(this.startLevels[c], this.engines[c], this.hard);
            ++c;
        }
        this.processAttacksSplitted();
    }

    public void processSplitted(Cmplx[] input, int chan, Cmplx[] shortx, Cmplx[] longx) {
        this.engines[chan].push(input);
        this.split(input, this.levels[chan], this.edgeRatio[chan]);
        this.extract(input, chan, shortx, longx);
    }

    public void processMixed(Cmplx[] input, int chan, Cmplx[] shortx, Cmplx[] longx) {
        this.split(input, this.commonLevels, this.edgeRatio[chan]);
        this.extract(input, chan, shortx, longx);
    }

    private void extract(Cmplx[] input, int chan, Cmplx[] shortx, Cmplx[] longx) {
        float[] eRatio = this.edgeRatio[chan];
        int i = 0;
        while (i < this.nbBins) {
            float edge = eRatio[i];
            float rest = 1.0f - edge;
            Cmplx data = input[i];
            shortx[i].set(data.re * edge, data.im * edge);
            longx[i].set(data.re * rest, data.im * rest);
            ++i;
        }
    }

    private void computeLevels(Cmplx[] input, float[] levels) {
        int i = 0;
        while (i < this.nbBins) {
            levels[i] = input[i].magApprox();
            ++i;
        }
    }

    private void fillSum(Cmplx[][] input) {
        Cmplx[] data0 = input[0];
        int i = 0;
        while (i < this.nbBins) {
            this.source[i].set(data0[i]);
            ++i;
        }
        int chan = 1;
        while (chan < input.length) {
            Cmplx[] datac = input[chan];
            int i2 = 0;
            while (i2 < this.nbBins) {
                this.source[i2].add(datac[i2]);
                ++i2;
            }
            ++chan;
        }
    }

    private void analyzeAttacks(BeatExtractEngine engine, float[] levels) {
        int i = 0;
        while (i < this.nbBins) {
            float threshold = this.getThreshold(engine, levels[i], i);
            if (levels[i] > threshold) {
                this.attacks.set(i);
            }
            ++i;
        }
    }

    private void analyzeAttacksMonitored(BeatExtractEngine engine, float[] levels, float[] monitorLevels) {
        int i = 0;
        while (i < this.nbBins) {
            float threshold = this.getThreshold(engine, levels[i], i);
            if (levels[i] > threshold && levels[i] * MAX_SKEW > monitorLevels[i]) {
                this.attacks.set(i);
            }
            ++i;
        }
    }

    private float getThreshold(BeatExtractEngine engine, float level, int i) {
        float thresholdNext;
        float thresholdPrev;
        float minAvgLevel = engine.getMinAvgLevel(i);
        if (minAvgLevel * this.maxJump < level) {
            float raise = level - minAvgLevel * this.maxJump;
            engine.raiseBy(i, raise);
        }
        float threshold = minAvgLevel * this.sensitivity;
        if (i > 0 && (thresholdPrev = engine.getMinAvgLevel(i - 1) * this.sensitivity) > threshold) {
            threshold = thresholdPrev;
        }
        if (i < this.nbBins - 1 && (thresholdNext = engine.getMinAvgLevel(i + 1) * this.sensitivity) > threshold) {
            threshold = thresholdNext;
        }
        if (threshold < this.floorLevel) {
            threshold = this.floorLevel;
        }
        return threshold;
    }

    private void updateAttacks(double attackSpeed) {
        int i = 0;
        while (i < this.nbBins) {
            if (this.commonAttackTimes[i] > 0) {
                int n = i;
                this.commonAttackTimes[n] = this.commonAttackTimes[n] - 1;
            } else {
                int n = i;
                this.commonAttackLevels[n] = (float)((double)this.commonAttackLevels[n] * attackSpeed);
                if (this.commonAttackLevels[i] > 10.0f) {
                    this.commonAttackLevels[i] = 10.0f;
                }
            }
            ++i;
        }
    }

    private void computeCommonlevels() {
        float correction = 1.0f / (float)this.nbChans;
        int i = 0;
        while (i < this.nbBins) {
            this.commonLevels[i] = this.levels[0][i] * correction;
            ++i;
        }
        int chan = 1;
        while (chan < this.nbChans) {
            int i2 = 0;
            while (i2 < this.nbBins) {
                int n = i2;
                this.commonLevels[n] = this.commonLevels[n] + this.levels[chan][i2] * correction;
                ++i2;
            }
            ++chan;
        }
    }

    private void applyMinSpan() {
        if (this.minSpan > 1) {
            int start = -1;
            int i = 0;
            while (i < this.nbBins) {
                boolean isShort = this.attacks.get(i);
                if (isShort) {
                    if (start < 0) {
                        start = i;
                    }
                } else if (start >= 0) {
                    int span;
                    int s = start;
                    if (s == 0) {
                        s = -(this.minSpan + 1) / 2;
                    }
                    if ((span = i - s) < this.minSpan) {
                        this.attacks.clear(start, i);
                    }
                    start = -1;
                }
                ++i;
            }
        }
    }

    private void applySpread() {
        if (this.spread <= 0) {
            return;
        }
        int count = 0;
        int i = 0;
        while (i < this.nbBins) {
            if (this.attacks.get(i)) {
                count = this.spread;
            } else if (count > 0) {
                this.attacks.set(i);
                --count;
            }
            ++i;
        }
        i = this.nbBins - 1;
        while (i >= 0) {
            if (this.attacks.get(i)) {
                count = this.spread;
            } else if (count > 0) {
                this.attacks.set(i);
                --count;
            }
            --i;
        }
    }

    private void fillStartLevels(float[] startLevels, BeatExtractEngine engine, boolean hard) {
        Arrays.fill(startLevels, 10.0f);
        if (hard) {
            float sumLevel = 0.0f;
            int startBin = -1;
            int i = 0;
            while (i <= this.nbBins) {
                if (i < this.nbBins && this.attacks.get(i)) {
                    if (startBin < 0) {
                        startBin = i;
                        sumLevel = 0.0f;
                    }
                    float level = engine.getMinAvgLevel(i);
                    sumLevel += level;
                } else if (startBin >= 0) {
                    int j = startBin;
                    while (j < i) {
                        startLevels[j] = sumLevel / (float)(i - startBin);
                        ++j;
                    }
                    startBin = -1;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.nbBins) {
                if (this.attacks.get(i)) {
                    startLevels[i] = engine.getMinAvgLevel(i);
                }
                ++i;
            }
        }
    }

    private void processAttacksMixed() {
        int i = 0;
        while (i < this.nbBins) {
            if (this.attacks.get(i)) {
                float newLevel = this.startLevels[0][i];
                if (newLevel < this.commonAttackLevels[i]) {
                    this.commonAttackLevels[i] = newLevel;
                }
                this.commonAttackTimes[i] = this.attackDelay;
            }
            ++i;
        }
    }

    private void processAttacksSplitted() {
        int i = 0;
        while (i < this.nbBins) {
            if (this.attacks.get(i)) {
                float minRatio = 1.0f;
                int chan = 0;
                while (chan < this.nbChans) {
                    float ratio;
                    float startLevel = this.startLevels[chan][i];
                    if (this.levels[chan][i] > FLOOR_LEVEL && (ratio = startLevel / this.levels[chan][i]) < minRatio) {
                        minRatio = ratio;
                    }
                    ++chan;
                }
                float newLevel = this.commonLevels[i] * minRatio;
                if (newLevel < this.commonAttackLevels[i]) {
                    this.commonAttackLevels[i] = newLevel;
                }
                this.commonAttackTimes[i] = this.attackDelay;
            }
            ++i;
        }
    }

    private void split(Cmplx[] input, float[] levels, float[] edgeRatio) {
        int i = 0;
        while (i < this.nbBins) {
            if (this.commonLevels[i] > FLOOR_LEVEL) {
                float ratio = this.commonAttackLevels[i] / this.commonLevels[i];
                float attackLevel = levels[i] * ratio;
                float level = input[i].magApprox();
                if (level > attackLevel) {
                    float cropped = attackLevel;
                    edgeRatio[i] = (level - cropped) / level;
                } else {
                    edgeRatio[i] = 0.0f;
                }
            } else {
                edgeRatio[i] = 0.0f;
            }
            ++i;
        }
    }
}

