/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.time;

import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.bouncelets.audio.base.WaveData;
import org.corebounce.decklight.bouncelets.audio.convert.format.asharp.Fork;
import org.corebounce.decklight.bouncelets.audio.convert.format.asharp.HqxMode;
import org.corebounce.decklight.bouncelets.audio.convert.format.asharp.KnifeInfo;
import org.corebounce.decklight.bouncelets.audio.convert.format.asharp.SharpInfo;
import org.corebounce.decklight.bouncelets.audio.ports.InAudio;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InBoolean;
import org.corebounce.decklight.ports.InDouble;
import org.corebounce.decklight.ports.InInt;
import org.corebounce.decklight.ports.InputPort;

public class ForkerBase
extends Bouncelet {
    public InAudio inAudio = new InAudio("in", "Input audio wave");
    public InInt inMinLength1 = new InInt("minLength1", "MinLength1", 24, 1, 100);
    public InInt inAvgLength1 = new InInt("avgLength1", "AvgLength1", 20, 1, 100);
    public InInt inMinSpan1 = new InInt("minSpan1", "MinSpan1", 10, 0, 40);
    public InInt inSpread1 = new InInt("spread1", "Spread1", 3, 0, 20);
    public InDouble inSensivity1 = new InDouble("sensivity1", "Sensivity1", 5.0, 0.0, 20.0);
    public InInt inTime1 = new InInt("time1", "Attack Time 1", 0, 0, 100);
    public InDouble inSpeed1 = new InDouble("speed1", "Attack Speed 1", 1.0, 0.0, 10.0);
    public InBoolean inHard1 = new InBoolean("hard1", "Hard 1", false);
    public InInt inMinLength2 = new InInt("minLength2", "MinLength2", 24, 1, 100);
    public InInt inAvgLength2 = new InInt("avgLength2", "AvgLength2", 20, 1, 100);
    public InInt inMinSpan2 = new InInt("minSpan2", "MinSpan2", 10, 0, 40);
    public InInt inSpread2 = new InInt("spread2", "Spread2", 3, 0, 20);
    public InDouble inSensivity2 = new InDouble("sensivity2", "Sensivity2", 5.0, 0.0, 20.0);
    public InInt inTime2 = new InInt("time2", "Attack Time 2", 0, 0, 100);
    public InDouble inSpeed2 = new InDouble("speed2", "Attack Speed 2", 3.0, 0.0, 10.0);
    public InBoolean inHard2 = new InBoolean("hard2", "Hard 2", false);
    public OutAudio outAudio0 = new OutAudio("out0", "Output audio wave 0");
    public OutAudio outAudio1 = new OutAudio("out1", "Output audio wave 1");
    public OutAudio outAudio2 = new OutAudio("out2", "Output audio wave 2");
    private final InputPort<?>[] inParams;
    private Fork engine;
    private int nbFrames;

    public ForkerBase() {
        super("audio.effect.fourier.time.forker-base", "Internal");
        InputPort<?>[] inputPortArray = this.inParams = new InputPort[]{this.inMinLength1, this.inAvgLength1, this.inMinSpan1, this.inSpread1, this.inSensivity1, this.inTime1, this.inSpeed1, this.inHard1, this.inMinLength2, this.inAvgLength2, this.inMinSpan2, this.inSpread2, this.inSensivity2, this.inTime2, this.inSpeed2, this.inHard2};
        int n = this.inParams.length;
        int n2 = 0;
        while (n2 < n) {
            InputPort<?> port = inputPortArray[n2];
            port.setSkillType(SkillType.ADVANCED);
            ++n2;
        }
    }

    public void cycle() {
        this.setup();
        this.process();
    }

    private void setup() {
        boolean changes = false;
        InputPort<?>[] inputPortArray = this.inParams;
        int n = this.inParams.length;
        int n2 = 0;
        while (n2 < n) {
            InputPort<?> port = inputPortArray[n2];
            if (port.isModified()) {
                changes = true;
                break;
            }
            ++n2;
        }
        WaveData inWave = (WaveData)this.inAudio.peek();
        if (this.engine == null || this.engine.getNbChans() != inWave.nbChannels || this.nbFrames != inWave.nbFrames || changes) {
            this.nbFrames = inWave.nbFrames;
            KnifeInfo info0 = new KnifeInfo(128, 32, (Integer)this.inMinLength1.read(), (Integer)this.inAvgLength1.read(), (Integer)this.inMinSpan1.read(), (Integer)this.inSpread1.read(), (Double)this.inSensivity1.read(), (Integer)this.inTime1.read(), (Double)this.inSpeed1.read(), (Boolean)this.inHard1.read());
            KnifeInfo info1 = new KnifeInfo(512, 128, (Integer)this.inMinLength2.read(), (Integer)this.inAvgLength2.read(), (Integer)this.inMinSpan2.read(), (Integer)this.inSpread2.read(), (Double)this.inSensivity2.read(), (Integer)this.inTime2.read(), (Double)this.inSpeed2.read(), (Boolean)this.inHard2.read());
            SharpInfo info = new SharpInfo(new KnifeInfo[]{info0, info1}, HqxMode.TRIPLE_HIGH.getInfo().layerInfo);
            this.engine = new Fork(inWave.nbChannels, info);
        }
    }

    private void process() {
        WaveData inWave = (WaveData)this.inAudio.read();
        this.outAudio0.prepare(inWave.nbChannels, inWave.nbFrames, inWave.windowing);
        this.outAudio1.prepare(inWave.nbChannels, inWave.nbFrames, inWave.windowing);
        this.outAudio2.prepare(inWave.nbChannels, inWave.nbFrames, inWave.windowing);
        WaveData outWave0 = (WaveData)this.outAudio0.get();
        WaveData outWave1 = (WaveData)this.outAudio1.get();
        WaveData outWave2 = (WaveData)this.outAudio2.get();
        this.engine.process(inWave.data);
        int chan = 0;
        while (chan < inWave.nbChannels) {
            System.arraycopy(this.engine.getOutput(0, chan), 0, outWave0.data[chan], 0, this.nbFrames);
            System.arraycopy(this.engine.getOutput(1, chan), 0, outWave1.data[chan], 0, this.nbFrames);
            System.arraycopy(this.engine.getOutput(2, chan), 0, outWave2.data[chan], 0, this.nbFrames);
            ++chan;
        }
    }
}

