/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.time;

import org.corebounce.common.math.Cmplx;
import org.corebounce.decklight.bouncelets.audio.base.AudioExtractSpectrumBouncelet;
import org.corebounce.decklight.bouncelets.audio.base.AudioMath;
import org.corebounce.decklight.bouncelets.audio.base.SpectrumData;
import org.corebounce.decklight.bouncelets.audio.effect.spectrum.time.BeatExtractEngine;
import org.corebounce.decklight.bouncelets.audio.ports.InSpectrum;
import org.corebounce.decklight.bouncelets.audio.ports.OutSpectrum;
import org.corebounce.decklight.bridge.ScaleType;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;
import org.corebounce.decklight.ports.InInt;
import org.corebounce.utils.Log;

public class RhythmExtract
extends AudioExtractSpectrumBouncelet {
    public InSpectrum inAudio = new InSpectrum("in", "Input audio spectrum");
    public InDouble inThreshold = new InDouble("threshold", "Duration threshold [s]", 0.1, 0.001, 10.0);
    public InDouble inSmoothing = new InDouble("smoothing", "Smoothing duration [s]", 0.03, 1.0E-4, 0.1);
    public InInt inAvgSpan = new InInt("avgspan", "Averaging [bins]", 20, 0, 50);
    public InDouble inGate = new InDouble("gate", "Cut gate level [dB]", 7.0, 0.0, 20.0);
    public OutSpectrum outRhythm = new OutSpectrum("rhythm", "Rhythm");
    public OutSpectrum outRest = new OutSpectrum("rest", "Rest");
    private BeatExtractEngine[] states;
    private float[] mountains;
    private float[] shadow;
    private int nbBins;

    public RhythmExtract() {
        super("audio.effect.spectrum.time.rhythm-x", "Extract rhythmics");
        super.setSkillType(SkillType.ADVANCED);
        this.inThreshold.setScaleType(ScaleType.LOG2);
        this.inSmoothing.setScaleType(ScaleType.LOG2);
        this.inAvgSpan.setScaleType(ScaleType.CUBE);
        this.inThreshold.setSkillType(SkillType.ADVANCED);
        this.inSmoothing.setSkillType(SkillType.ADVANCED);
        this.inAvgSpan.setSkillType(SkillType.ADVANCED);
    }

    protected OutSpectrum getOutput1() {
        return this.outRhythm;
    }

    protected OutSpectrum getOutput2() {
        return this.outRest;
    }

    protected BeatExtractEngine[] createStates(int nbChans) {
        int avgLength;
        SpectrumData audio = (SpectrumData)this.inAudio.peek();
        this.nbBins = audio.nbBins;
        int length = (int)((Double)this.inThreshold.read() / audio.getRealDuration() + 0.5);
        if (length < 1) {
            length = 1;
        }
        if ((avgLength = (int)((Double)this.inSmoothing.read() / audio.getRealDuration() + 0.5)) < 1) {
            avgLength = 1;
        }
        Log.debug("Length={0}; Avg Length={1}", length, avgLength);
        BeatExtractEngine[] result = new BeatExtractEngine[nbChans];
        int i = 0;
        while (i < nbChans) {
            result[i] = new BeatExtractEngine(audio.nbBins, length, avgLength);
            ++i;
        }
        this.mountains = new float[audio.nbBins];
        this.shadow = new float[audio.nbBins];
        return result;
    }

    protected void setup() {
        SpectrumData audio = (SpectrumData)this.inAudio.peek();
        if (this.states == null || this.states.length != audio.nbChannels || this.nbBins != audio.nbBins || this.inThreshold.isModified() || this.inSmoothing.isModified()) {
            this.states = this.createStates(audio.nbChannels);
        }
    }

    public void process(int chan, Cmplx[] input, Cmplx[] outRhythm, Cmplx[] outRest) {
        BeatExtractEngine engine = this.states[chan];
        engine.push(input);
        int i = 0;
        while (i < input.length) {
            float roughnessNext;
            float roughnessPrev;
            float level = input[i].magApprox();
            float roughness = this.getRoughness(engine, level, i);
            if (i > 0 && (roughnessPrev = this.getRoughness(engine, level, i - 1)) < roughness) {
                roughness = roughnessPrev;
            }
            if (i < input.length - 1 && (roughnessNext = this.getRoughness(engine, level, i + 1)) < roughness) {
                roughness = roughnessNext;
            }
            this.mountains[i] = (float)AudioMath.levelToDb0(roughness);
            ++i;
        }
        int avgSpan = (Integer)this.inAvgSpan.read();
        float sum = 0.0f;
        int i2 = -avgSpan;
        while (i2 < avgSpan) {
            sum += this.pick(i2);
            ++i2;
        }
        float correction = 1.0f / (float)(avgSpan * 2 + 1);
        int i3 = 0;
        while (i3 < input.length) {
            this.shadow[i3] = (sum += this.pick(i3 + avgSpan)) * correction;
            sum -= this.pick(i3 - avgSpan);
            ++i3;
        }
        float gate = (float)((Double)this.inGate.read()).doubleValue();
        int i4 = 0;
        while (i4 < input.length) {
            float level = this.shadow[i4];
            if (level < gate) {
                outRhythm[i4].clear();
                outRest[i4].set(input[i4]);
            } else {
                outRhythm[i4].set(input[i4]);
                outRest[i4].clear();
            }
            ++i4;
        }
    }

    private float getRoughness(BeatExtractEngine engine, float level, int binNum) {
        float minAvg = engine.getMinAvgLevel(binNum);
        if (level > minAvg && minAvg != 0.0f) {
            return level / minAvg;
        }
        return 1.0f;
    }

    private float pick(int index) {
        if (index < 0) {
            return this.mountains[-index];
        }
        if (index >= this.nbBins) {
            return this.mountains[this.nbBins * 2 - index - 1];
        }
        return this.mountains[index];
    }
}

