/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.tone;

import org.corebounce.common.math.Cmplx;
import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.GraphErrorType;
import org.corebounce.decklight.bouncelets.audio.base.SpectrumData;
import org.corebounce.decklight.bouncelets.audio.ports.InSpectrum;
import org.corebounce.decklight.bouncelets.audio.ports.OutSpectrum;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InBoolean;
import org.corebounce.utils.Severity;

public class Cross
extends Bouncelet {
    public InSpectrum inAudio1 = new InSpectrum("in1", "First input audio spectrum");
    public InSpectrum inAudio2 = new InSpectrum("in2", "Second input audio spectrum");
    public InBoolean inPreserve = new InBoolean("preserve", "Preserve minimum energy", true);
    public OutSpectrum outAudio = new OutSpectrum("out", "Output audio spectrum");

    public Cross() {
        super("audio.effect.spectrum.tone.cross", "Multiply two spectrums together");
        super.setSkillType(SkillType.ADVANCED);
        this.inPreserve.setSkillType(SkillType.ADVANCED);
    }

    public void cycle() {
        SpectrumData spectrum1 = (SpectrumData)this.inAudio1.read();
        SpectrumData spectrum2 = (SpectrumData)this.inAudio2.read();
        boolean changes = this.outAudio.prepare(spectrum1);
        if (changes) {
            if (spectrum1.nbBins != spectrum2.nbBins) {
                super.log(GraphErrorType.IllegalArgument, Severity.Error, "Spectrums have not the same sizes ({0} and {1})", spectrum1.nbBins, spectrum2.nbBins);
            }
            if (spectrum1.nbChannels != spectrum2.nbChannels) {
                super.log(GraphErrorType.IllegalArgument, Severity.Warning, "Spectrum have not the same number of channels ({0} and {1})", spectrum1.nbChannels, spectrum2.nbChannels);
            }
        }
        SpectrumData outSpectrum = (SpectrumData)this.outAudio.get();
        int chan = 0;
        while (chan < spectrum1.nbChannels) {
            Cmplx[] input1 = spectrum1.data[chan];
            Cmplx[] input2 = spectrum2.data[chan % spectrum2.nbChannels];
            Cmplx[] output = outSpectrum.data[chan];
            float srcEnergy1 = 0.0f;
            float srcEnergy2 = 0.0f;
            float dstEnergy = 0.0f;
            int i = 0;
            while (i < output.length) {
                srcEnergy1 += input1[i].powerMag();
                srcEnergy2 += input2[i].powerMag();
                output[i].prod(input1[i], input2[i]);
                dstEnergy += output[i].powerMag();
                ++i;
            }
            if (dstEnergy > 0.0f && ((Boolean)this.inPreserve.read()).booleanValue()) {
                float correction = srcEnergy1 < srcEnergy2 ? srcEnergy1 / dstEnergy : srcEnergy2 / dstEnergy;
                int i2 = 0;
                while (i2 < output.length) {
                    output[i2].mul(correction);
                    ++i2;
                }
            }
            ++chan;
        }
    }
}

