/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.tone;

import java.util.Random;
import org.corebounce.common.math.Cmplx;
import org.corebounce.decklight.bouncelets.audio.base.AudioMonoSpectrumBouncelet;
import org.corebounce.decklight.bouncelets.audio.ports.InSpectrum;
import org.corebounce.decklight.bouncelets.audio.ports.OutSpectrum;
import org.corebounce.decklight.bridge.ScaleType;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;

public class Shake
extends AudioMonoSpectrumBouncelet {
    public InSpectrum inAudio = new InSpectrum("in", "Input audio spectrum");
    public InDouble inAmount = new InDouble("amount", "Shake amount", 0.25, 0.0, 1.0);
    public InDouble inHighest = new InDouble("highest", "Highest frequency (relative to Nyquist)", 0.3, 0.1, 1.0);
    public OutSpectrum outAudio = new OutSpectrum("out", "Output audio spectrum");
    private Random random;
    private int seed = 0;

    public Shake() {
        super("audio.effect.spectrum.tone.shake", "Shake random bin positions", false);
        super.setSkillType(SkillType.ADVANCED);
        this.inHighest.setScaleType(ScaleType.LOG2);
        this.inAmount.setSkillType(SkillType.SIMPLIFIED);
    }

    public void init() {
        super.init();
        this.random = new Random();
    }

    protected void setup() {
        ++this.seed;
    }

    public void process(Cmplx[] input, Cmplx[] output) {
        int i;
        assert (input.length == output.length);
        int highest = (int)((double)output.length * (Double)this.inHighest.read());
        double amount = (Double)this.inAmount.read();
        int count = (int)((double)highest * amount / 2.0);
        this.random.setSeed(this.seed);
        if (input != output) {
            i = 0;
            while (i < output.length) {
                output[i].set(input[i]);
                ++i;
            }
        }
        i = 0;
        while (i < count) {
            double ss = Math.expm1(this.random.nextDouble()) / 1.718281828459045;
            assert (ss >= 0.0 && ss <= 1.0);
            int index1 = (int)(ss * (double)highest) % highest;
            int index2 = index1 + (int)(this.random.nextGaussian() * (double)count);
            if (index2 < 0) {
                index2 = highest - -index2 % highest;
            } else if (index2 >= highest) {
                index2 %= highest;
            }
            if (index1 != index2) {
                output[index1].swapWith(output[index2]);
            }
            ++i;
        }
    }
}

