/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.tone;

import org.corebounce.common.math.Cmplx;
import org.corebounce.decklight.bouncelets.audio.base.SpectrumData;
import org.corebounce.decklight.bouncelets.audio.effect.spectrum.pitch.PhaseLockedVocoder;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;

public class SpectralDepriever
extends PhaseLockedVocoder {
    public InDouble inShrink = new InDouble("shrink", "Ratio between shrunk and original spectral peak widths", 1.0, 0.0, 1.0);
    private double shrink;
    private Cmplx[] buffer;

    public SpectralDepriever() {
        super("audio.effect.spectrum.tone.spectral-depriever", "Narrows spectral peaks");
        this.inShrink.setSkillType(SkillType.SIMPLIFIED);
    }

    protected void setup() {
        super.setup();
        if (this.inShrink.isModified()) {
            this.shrink = (Double)this.inShrink.read();
        }
        SpectrumData srcSpectrum = (SpectrumData)this.inSpectrum.peek();
        if (this.buffer == null || this.buffer.length != srcSpectrum.nbBins) {
            this.buffer = Cmplx.newArray(srcSpectrum.nbBins);
        }
    }

    protected double getModifiedFreq(int resultNum, double binFreq) {
        return binFreq;
    }

    protected Cmplx[] preSynthesize(Cmplx[] input, int nbPeaks, int[] bounds) {
        int i = 0;
        while (i < nbPeaks) {
            int stop;
            int start = i == 0 ? 0 : bounds[i - 1];
            int n = stop = i == nbPeaks - 1 ? input.length : bounds[i];
            if (stop > start) {
                int peak = this.getPeakIndex(input, start, stop);
                float srcEnergy = 0.0f;
                float dstEnergy = 0.0f;
                int j = start;
                while (j < stop) {
                    float targetMagPos = peak;
                    if (j < peak) {
                        targetMagPos -= (float)(peak - j) / (float)this.shrink;
                    } else if (j > peak) {
                        targetMagPos += (float)(j - peak) / (float)this.shrink;
                    }
                    float targetMag = 0.0f;
                    if (!Float.isInfinite(targetMagPos)) {
                        targetMag = this.getMagInterpolate(input, targetMagPos, start, stop);
                    }
                    float srcMag = input[j].powerMag();
                    srcEnergy += srcMag;
                    this.buffer[j].copyFrom(input[j]);
                    if (srcMag > 0.0f) {
                        this.buffer[j].mul(targetMag / srcMag);
                    }
                    dstEnergy += this.buffer[j].powerMag();
                    ++j;
                }
                if (dstEnergy > 0.0f) {
                    float correction = (float)Math.sqrt(srcEnergy / dstEnergy);
                    int j2 = start;
                    while (j2 < stop) {
                        this.buffer[j2].mul(correction);
                        ++j2;
                    }
                }
            }
            ++i;
        }
        return this.buffer;
    }

    private int getPeakIndex(Cmplx[] input, int start, int stop) {
        float maxMag = Float.NEGATIVE_INFINITY;
        int peakIndex = start;
        int j = start;
        while (j < stop) {
            float mag = input[j].powerMag();
            if (mag > maxMag) {
                maxMag = mag;
                peakIndex = j;
            }
            ++j;
        }
        return peakIndex;
    }

    private float getMag(Cmplx[] input, int index, int start, int stop) {
        if (index < start || index >= stop) {
            return 0.0f;
        }
        return input[index].powerMag();
    }

    private float getMagInterpolate(Cmplx[] input, float index, int start, int stop) {
        int i1 = (int)index;
        float w2 = index - (float)i1;
        float mag1 = this.getMag(input, i1, start, stop);
        float mag2 = this.getMag(input, i1 + 1, start, stop);
        return mag1 + (mag2 - mag1) * w2;
    }
}

