/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.spectrum.tone;

import org.corebounce.common.math.Cmplx;
import org.corebounce.decklight.bouncelets.audio.base.AudioStateSpectrumBouncelet;
import org.corebounce.decklight.bouncelets.audio.base.PowerOf2;
import org.corebounce.decklight.bouncelets.audio.base.SpectrumData;
import org.corebounce.decklight.bouncelets.audio.ports.InSpectrum;
import org.corebounce.decklight.bouncelets.audio.ports.InSpectrumPreset;
import org.corebounce.decklight.bouncelets.audio.ports.OutSpectrum;
import org.corebounce.decklight.bouncelets.audio.ports.PortValueSetter;
import org.corebounce.decklight.bouncelets.audio.ports.Presetter;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InBoolean;
import org.corebounce.decklight.ports.InDouble;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Zombify
extends AudioStateSpectrumBouncelet<double[]> {
    public InSpectrum inAudio = new InSpectrum("in", "Input audio spectrum");
    public InDouble inDegree = new InDouble("degree", "Degree of putrefaction", 1.7, 1.0, 2.0);
    public InBoolean inBoost = new InBoolean("boost", "Boost amplitude", true);
    public InSpectrumPreset<Zombify, Preset> inMode = new InSpectrumPreset(Preset.class, "mode", "Reincarnation type", Preset.LIGHT);
    public OutSpectrum outAudio = new OutSpectrum("out", "Zombified audio spectrum");
    private double factor;
    private int nbChannels = 0;
    private int nbBins = 0;
    private float[] corrections;
    private float boost = 1.0f;

    public Zombify() {
        super("audio.effect.spectrum.tone.zombify", "Hehe :-)");
        super.setSkillType(SkillType.ADVANCED);
        this.inDegree.setSkillType(SkillType.SIMPLIFIED);
        this.inMode.setSkillType(SkillType.SIMPLIFIED);
        this.inBoost.setSkillType(SkillType.EXPERT);
    }

    @Override
    public boolean checkForChanges() {
        boolean changes = false;
        SpectrumData spectrum = (SpectrumData)this.inAudio.peek();
        if (spectrum.nbBins != this.nbBins || spectrum.nbChannels != this.nbChannels) {
            this.nbBins = spectrum.nbBins;
            this.nbChannels = spectrum.nbChannels;
            this.corrections = new float[spectrum.nbChannels];
            changes = true;
        }
        if (changes || this.inDegree.isModified()) {
            double degree = ((Double)this.inDegree.read() - 1.0) * spectrum.getRealDuration() / 0.0029024943310657597;
            this.factor = Math.pow(0.5, degree);
            this.factor = this.factor * 1000.0 * spectrum.getRealDuration();
        }
        if (this.inBoost.isModified()) {
            this.boost = (Boolean)this.inBoost.read() != false ? 2.0f : 1.0f;
        }
        return changes;
    }

    protected double[][] createStates(int nbChans) {
        return new double[nbChans][this.nbBins];
    }

    @Override
    public void process(double[] state, int chan, Cmplx[] input, Cmplx[] output) {
        float newCorrection;
        double srcEnergy = 0.0;
        double dstEnergy = 0.0;
        int i = 0;
        while (i < input.length) {
            srcEnergy += (double)input[i].powerMag();
            double norm = input[i].magApprox();
            double delta = norm - state[i];
            if (delta > 0.0) {
                delta *= this.factor;
            } else if (delta < 0.0) {
                delta *= this.factor;
            }
            double newNorm = state[i] + delta;
            if (newNorm < 0.0) {
                newNorm = 0.0;
            }
            double ratio = norm > 0.001 ? newNorm / norm : 1.0;
            output[i].set(input[i]);
            output[i].mul((float)(1.0 - ratio));
            dstEnergy += (double)output[i].powerMag();
            state[i] = newNorm;
            ++i;
        }
        if ((float)dstEnergy > 0.0f && (newCorrection = (float)Math.sqrt(srcEnergy / dstEnergy) * this.boost) < 100.0f) {
            float correction;
            this.corrections[chan] = correction = this.corrections[chan] * 0.9f + newCorrection * 0.1f;
            int i2 = 0;
            while (i2 < output.length) {
                output[i2].mul(correction);
                ++i2;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Preset implements Presetter<Zombify>
    {
        LIGHT{

            public void apply(Zombify bouncelet, PortValueSetter setter) {
                setter.setBlockSize(PowerOf2.p1024);
                setter.setOverlap(PowerOf2.p4);
                setter.setPortValue(bouncelet.inBoost, true);
            }
        }
        ,
        MEDIUM{

            public void apply(Zombify bouncelet, PortValueSetter setter) {
                setter.setBlockSize(PowerOf2.p512);
                setter.setOverlap(PowerOf2.p4);
                setter.setPortValue(bouncelet.inBoost, true);
            }
        }
        ,
        HARD{

            public void apply(Zombify bouncelet, PortValueSetter setter) {
                setter.setBlockSize(PowerOf2.p512);
                setter.setOverlap(PowerOf2.p2);
                setter.setPortValue(bouncelet.inBoost, false);
            }
        };

    }
}

