/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.wave.amplitude;

import org.corebounce.decklight.bouncelets.audio.base.AudioMonoWaveBouncelet;
import org.corebounce.decklight.bouncelets.audio.ports.InAudio;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;
import org.corebounce.decklight.bridge.ScaleType;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;

public class InterFrequencyModulation
extends AudioMonoWaveBouncelet {
    public InAudio inAudio = new InAudio("in", "Input Channel");
    public InDouble inStrength = new InDouble("strength", "DRY/WET levels", 0.1, 0.0, 1.0);
    public OutAudio outAudio = new OutAudio("out", "Output Channel");

    public InterFrequencyModulation() {
        super("audio.effect.wave.amplitude.IFM", "Inter-frequency modulation distortion");
        super.setSkillType(SkillType.NORMAL);
        this.inStrength.setSkillType(SkillType.SIMPLIFIED);
        this.inStrength.setScaleType(ScaleType.CUBEROOT);
    }

    public void process(float[] input, float[] output) {
        double strength = (Double)this.inStrength.read();
        float dryLevel = (float)Math.sqrt(1.0 - strength);
        float wetLevel = (float)Math.sqrt(strength);
        int i = 0;
        while (i < input.length) {
            float dry = input[i];
            float wet = dry * dry;
            output[i] = dry * dryLevel + wet * wetLevel;
            ++i;
        }
    }
}

