/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.wave.amplitude;

import org.corebounce.decklight.bouncelets.audio.base.AudioMath;
import org.corebounce.decklight.bouncelets.audio.base.AudioStateWaveBouncelet;
import org.corebounce.decklight.bouncelets.audio.base.WaveData;
import org.corebounce.decklight.bouncelets.audio.effect.wave.amplitude.NoiseGateEngine;
import org.corebounce.decklight.bouncelets.audio.ports.InAudio;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;
import org.corebounce.decklight.bridge.ScaleType;
import org.corebounce.decklight.ports.InDouble;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NoiseGate
extends AudioStateWaveBouncelet<NoiseGateEngine> {
    public InAudio inAudio = new InAudio("in", "Input audio wave");
    public InDouble inLower = new InDouble("lower", "Lower Noise threshold [db]", -40.0, -100.0, 100.0);
    public InDouble inUpper = new InDouble("upper", "Upper Noise threshold [db]", -20.0, -100.0, 100.0);
    public InDouble inSmoothing = new InDouble("smoothing", "Smoothing duration [s]", 0.1, 1.0E-4, 1.0);
    public OutAudio outAudio = new OutAudio("out", "Output audio wave");
    private float lower;
    private float upper;

    public NoiseGate() {
        super("audio.effect.wave.amplitude.noisegate", "Filter audio below a threshold");
        this.inSmoothing.setScaleType(ScaleType.LOG2);
    }

    @Override
    public boolean checkForChanges() {
        return this.inSmoothing.isModified();
    }

    protected NoiseGateEngine[] createStates(int nbChans) {
        WaveData wave = (WaveData)this.inAudio.peek();
        int count = (int)((Double)this.inSmoothing.read() / wave.getRealDuration());
        if (count < 1) {
            count = 1;
        }
        NoiseGateEngine[] result = new NoiseGateEngine[nbChans];
        int i = 0;
        while (i < nbChans) {
            result[i] = new NoiseGateEngine(count);
            ++i;
        }
        return result;
    }

    @Override
    public void setup(boolean changes) {
        if (this.inLower.isModified()) {
            this.lower = (float)AudioMath.dbToLevel((Double)this.inLower.read());
        }
        if (this.inUpper.isModified()) {
            this.upper = (float)AudioMath.dbToLevel((Double)this.inUpper.read());
        }
        super.setup(changes);
    }

    @Override
    public void process(NoiseGateEngine state, float[] input, float[] output) {
        assert (input.length == output.length);
        int i = 0;
        while (i < input.length) {
            float threshold;
            float level = Math.abs(input[i]);
            state.push(level);
            float f = threshold = state.isBelow() ? this.upper : this.lower;
            if (level < threshold && state.getAverage() < threshold) {
                output[i] = 0.0f;
                state.setBelow(true);
            } else {
                output[i] = input[i];
                state.setBelow(false);
            }
            ++i;
        }
    }
}

