/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.wave.amplitude;

import org.corebounce.decklight.bouncelets.audio.base.AudioMath;
import org.corebounce.decklight.bouncelets.audio.base.AudioMonoWaveBouncelet;
import org.corebounce.decklight.bouncelets.audio.ports.InAudio;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;

public class Saturate
extends AudioMonoWaveBouncelet {
    public InAudio inAudio = new InAudio("in", "Input Channel");
    public InDouble inBoost = new InDouble("boost", "Gain boost", 10.0, 0.0, 100.0);
    public InDouble inCut = new InDouble("cut", "Gain cut", -20.0, -100.0, 0.0);
    public OutAudio outAudio = new OutAudio("out", "Output Channel");
    private double boostFactor;
    private double cutLevel;

    public Saturate() {
        super("audio.effect.wave.amplitude.saturate", "Raise volume with cutting", true);
        super.setSkillType(SkillType.SIMPLIFIED);
        this.inBoost.setSkillType(SkillType.SIMPLIFIED);
        this.inCut.setSkillType(SkillType.SIMPLIFIED);
    }

    public void cycle() {
        if (this.inBoost.isModified()) {
            this.boostFactor = AudioMath.dbToLevel((Double)this.inBoost.read());
        }
        if (this.inCut.isModified()) {
            this.cutLevel = AudioMath.dbToLevel((Double)this.inCut.read());
        }
        super.cycle();
    }

    public void process(float[] input, float[] output) {
        int i = 0;
        while (i < input.length) {
            double value = (double)input[i] * this.boostFactor;
            if (value > this.cutLevel) {
                value = this.cutLevel;
            } else if (-value > this.cutLevel) {
                value = -this.cutLevel;
            }
            output[i] = (float)value;
            ++i;
        }
    }
}

