/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.wave.echo;

import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.GraphErrorType;
import org.corebounce.decklight.bouncelets.audio.Buffer;
import org.corebounce.decklight.bouncelets.audio.base.AudioConfig;
import org.corebounce.decklight.bouncelets.audio.base.WaveData;
import org.corebounce.decklight.bouncelets.audio.ports.InAudio;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;
import org.corebounce.decklight.bridge.ScaleType;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;
import org.corebounce.utils.Severity;

public class ClimbEcho
extends Bouncelet {
    public InAudio inAudio = new InAudio("in", "Audio input wave");
    public InDouble inDelay = new InDouble("delay", "Echo delay [s]", 0.3, 0.0, 2.0);
    public InDouble inSide = new InDouble("level.side", "Side echo level", 0.5, 0.0, 1.0);
    public InDouble inCenter = new InDouble("level.center", "Center echo level", 0.2, 0.0, 1.0);
    public OutAudio outAudio = new OutAudio("out", "Audio output wave");
    private Buffer pingBuffer;
    private Buffer pongBuffer;
    private double correction = 1.0;

    public ClimbEcho() {
        super("audio.effect.wave.echo.climb-echo", "Echo from center to sides toward the center");
        super.setSkillType(SkillType.SIMPLIFIED);
        this.inDelay.setScaleType(ScaleType.LOG2);
    }

    public void cycle() {
        this.setup();
        this.process();
    }

    private void setup() {
        if (this.inDelay.isModified()) {
            int size = (int)((Double)this.inDelay.read() * (double)AudioConfig.getSampleRate());
            if (size < 1) {
                size = 1;
            }
            if (this.pingBuffer == null) {
                this.pingBuffer = new Buffer(size);
            } else {
                this.pingBuffer.setSize(size);
            }
            if (this.pongBuffer == null) {
                this.pongBuffer = new Buffer(size);
            } else {
                this.pongBuffer.setSize(size);
            }
        }
        if (this.inSide.isModified() || this.inCenter.isModified()) {
            double volume;
            double center;
            double side = Math.abs((Double)this.inSide.peek());
            double total = side + (center = Math.abs((Double)this.inCenter.peek()));
            if (total >= 1.0) {
                super.log(GraphErrorType.IllegalArgument, Severity.Warning, "The echo is unstable. Sum of levels {0} >= 1", total);
                volume = 100.0;
            } else {
                volume = 1.0 / (1.0 - total);
            }
            this.correction = 2.0 / (volume + 1.0);
        }
    }

    private void process() {
        WaveData inWave = (WaveData)this.inAudio.read();
        this.outAudio.prepare(2, inWave.nbFrames, inWave.windowing);
        WaveData outWave = (WaveData)this.outAudio.get();
        double sideLevel = (Double)this.inSide.read();
        double centerLevel = (Double)this.inCenter.read();
        float[] leftInput = inWave.data[0];
        float[] rightInput = inWave.nbChannels < 2 ? inWave.data[0] : inWave.data[1];
        float[] leftOutput = outWave.data[0];
        float[] rightOutput = outWave.data[1];
        int i = 0;
        while (i < inWave.nbFrames) {
            double inl = (double)leftInput[i] * this.correction;
            double inr = (double)rightInput[i] * this.correction;
            double in = (inl + inr) / 2.0;
            double ping = this.pingBuffer.peek();
            double pong = this.pongBuffer.peek();
            double newPing = in + pong * sideLevel;
            double newPong = ping * sideLevel;
            this.pingBuffer.push(newPing + newPong * centerLevel);
            this.pongBuffer.push(newPong + newPing * centerLevel);
            double out0 = inl + ping * sideLevel;
            double out1 = inr + pong * sideLevel;
            leftOutput[i] = (float)out0;
            rightOutput[i] = (float)out1;
            ++i;
        }
    }
}

