/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.wave.echo;

public class EchoEngine {
    private final int size;
    private final float[] lastInputs;
    private final float[] lastOutputs;
    private int index = -1;

    public EchoEngine(int size) {
        this.size = size;
        this.lastInputs = new float[size];
        this.lastOutputs = new float[size];
    }

    public EchoEngine(int size, EchoEngine previous) {
        this(size);
        int amount = this.size < previous.size ? this.size : previous.size;
        int i = 0;
        while (i < amount) {
            int srcIndex = (previous.size + previous.index - i) % previous.size;
            int dstIndex = this.size - i - 1;
            this.lastInputs[dstIndex] = previous.lastInputs[srcIndex];
            this.lastOutputs[dstIndex] = previous.lastOutputs[srcIndex];
            ++i;
        }
    }

    public double getPastInput(int time) {
        assert (time < this.size);
        return this.lastInputs[(this.size + this.index - time) % this.size];
    }

    public double getPastOutput(int time) {
        assert (time <= this.size && time > 0);
        return this.lastOutputs[(this.size + this.index - time) % this.size];
    }

    public void pushInput(double input) {
        ++this.index;
        if (this.index >= this.size) {
            this.index = 0;
        }
        this.lastInputs[this.index] = (float)input;
    }

    public void pushOutput(double output) {
        this.lastOutputs[this.index] = (float)output;
    }
}

