/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.wave.filter;

import org.corebounce.decklight.bouncelets.audio.base.AudioConfig;
import org.corebounce.decklight.bouncelets.audio.base.AudioMath;
import org.corebounce.decklight.bouncelets.audio.base.AudioStateWaveBouncelet;
import org.corebounce.decklight.bouncelets.audio.effect.wave.filter.DjEngine;
import org.corebounce.decklight.bouncelets.audio.ports.InAudio;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;
import org.corebounce.decklight.bridge.ScaleType;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DjEqualizer
extends AudioStateWaveBouncelet<DjEngine> {
    public InAudio inAudio = new InAudio("in", "Audio input wave");
    public InDouble inLow = new InDouble("low", "Low band level [dB]", 0.0, -100.0, 20.0);
    public InDouble inMid = new InDouble("mid", "Middle band level [dB]", 0.0, -100.0, 20.0);
    public InDouble inHigh = new InDouble("high", "High band level [dB]", 0.0, -100.0, 20.0);
    public InDouble inLowCut = new InDouble("cut.low", "Lowpass cutoff frequency", 500.0, 1.0, AudioConfig.MAX_FREQUENCY);
    public InDouble inHighCut = new InDouble("cut.high", "Highpass cutoff frequency", 1000.0, 1.0, AudioConfig.MAX_FREQUENCY);
    public OutAudio outAudio = new OutAudio("out", "Output audio wave");
    private double lowLevel;
    private double midLevel;
    private double highLevel;

    public DjEqualizer() {
        super("audio.effect.wave.filter.djeq", "DJ three bands equalizer", true);
        super.setSkillType(SkillType.SIMPLIFIED);
        this.inLowCut.setScaleType(ScaleType.LOG2);
        this.inHighCut.setScaleType(ScaleType.LOG2);
        this.inLow.setSkillType(SkillType.SIMPLIFIED);
        this.inMid.setSkillType(SkillType.SIMPLIFIED);
        this.inHigh.setSkillType(SkillType.SIMPLIFIED);
    }

    @Override
    public boolean checkForChanges() {
        return this.inLowCut.isModified() || this.inHighCut.isModified();
    }

    protected DjEngine[] createStates(int nbChans) {
        double lowFrequencyCut = (Double)this.inLowCut.read();
        double highFrequencyCut = (Double)this.inHighCut.read();
        DjEngine[] result = new DjEngine[nbChans];
        int c = 0;
        while (c < nbChans) {
            result[c] = new DjEngine(lowFrequencyCut, highFrequencyCut);
            ++c;
        }
        return result;
    }

    @Override
    public void setup(boolean changes) {
        if (this.inLow.isModified()) {
            this.lowLevel = AudioMath.dbToLevel((Double)this.inLow.read());
        }
        if (this.inMid.isModified()) {
            this.midLevel = AudioMath.dbToLevel((Double)this.inMid.read());
        }
        if (this.inHigh.isModified()) {
            this.highLevel = AudioMath.dbToLevel((Double)this.inHigh.read());
        }
    }

    @Override
    public void process(DjEngine state, float[] input, float[] output) {
        assert (input.length == output.length);
        state.setLowLevel((float)this.lowLevel);
        state.setMidLevel((float)this.midLevel);
        state.setHighLevel((float)this.highLevel);
        state.apply(input, output);
    }
}

