/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.wave.filter;

import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.bouncelets.audio.effect.wave.filter.Equalizer;
import org.corebounce.decklight.bouncelets.signal.Mul;
import org.corebounce.decklight.bouncelets.signal.values.Double;
import org.corebounce.decklight.macro.Connector;
import org.corebounce.decklight.macro.MacroBouncelet;
import org.corebounce.decklight.ports.InputPort;
import org.corebounce.decklight.ports.OutputPort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JumboEqualizer
extends MacroBouncelet {
    private static final int BANDS_COUNT = 10;
    private static final int CASCADE_COUNT = 3;
    private final Double[] levels = new Double[10];
    private final Mul[] multipliers = new Mul[10];
    private final Equalizer[] equalizers;

    public JumboEqualizer() {
        super("audio.effect.wave.filter.equalizer-jumbo", "Ten bands strong equalizer");
        int i = 0;
        while (i < 10) {
            this.levels[i] = new Double("band" + i, "Band level", 0.0, -100.0, 20.0);
            this.multipliers[i] = new Mul();
            ++i;
        }
        this.equalizers = new Equalizer[3];
        i = 0;
        while (i < 3) {
            this.equalizers[i] = new Equalizer();
            ++i;
        }
    }

    public Bouncelet[] getParts() {
        Bouncelet[] result = new Bouncelet[23];
        int dst = 0;
        int i = 0;
        while (i < 10) {
            result[dst++] = this.levels[i];
            result[dst++] = this.multipliers[i];
            ++i;
        }
        i = 0;
        while (i < 3) {
            result[dst++] = this.equalizers[i];
            ++i;
        }
        return result;
    }

    @Override
    public void createInternalConnections(Connector connector) {
        int i = 0;
        while (i < 10) {
            connector.connect(this.levels[i].outDouble, this.multipliers[i].inValue1);
            this.multipliers[i].inValue2.write(0.3333333333333333);
            int j = 0;
            while (j < 3) {
                connector.connect(this.multipliers[i].outResult, this.equalizers[j].getBand(i));
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 2) {
            connector.connect(this.equalizers[i].outAudio, this.equalizers[i + 1].inAudio);
            this.equalizers[i].inZeroFlat.write(true);
            ++i;
        }
    }

    @Override
    protected InputPort<?>[] getMacroInputPorts() {
        InputPort[] result = new InputPort[11];
        result[0] = this.equalizers[0].inAudio;
        int i = 0;
        while (i < 10) {
            result[i + 1] = this.levels[i].inDouble;
            ++i;
        }
        return result;
    }

    @Override
    protected OutputPort<?>[] getMacroOutputPorts() {
        return new OutputPort[]{this.equalizers[2].outAudio};
    }
}

