/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.wave.filter.flow;

import java.util.Arrays;
import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.bouncelets.audio.base.WaveData;
import org.corebounce.decklight.bouncelets.audio.ports.InAudio;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;
import org.corebounce.decklight.bridge.SkillType;

public class BandMerger
extends Bouncelet {
    private static final int NB_BANDS = 10;
    public InAudio inAudio = new InAudio("in", "Input audio bands (10 bands per original channel)");
    public OutAudio outAudio = new OutAudio("out", "Output audio wave");

    public BandMerger() {
        super("audio.effect.wave.filter.flow.bandmerge", "Merge audio bands");
        super.setSkillType(SkillType.ADVANCED);
    }

    public void cycle() {
        float correction = 5.0f;
        WaveData inWave = (WaveData)this.inAudio.read();
        int nbChannels = inWave.nbChannels / 10;
        int outChannels = nbChannels <= 0 ? 2 : nbChannels;
        this.outAudio.prepare(outChannels, inWave.nbFrames, inWave.windowing);
        WaveData outWave = (WaveData)this.outAudio.get();
        int chan = 0;
        while (chan < nbChannels) {
            float[] output = outWave.data[chan];
            Arrays.fill(output, 0.0f);
            int b = 0;
            while (b < 10) {
                float[] input = inWave.data[chan * 10 + b];
                int i = 0;
                while (i < output.length) {
                    int n = i;
                    output[n] = output[n] + input[i] / correction;
                    ++i;
                }
                ++b;
            }
            ++chan;
        }
    }
}

