/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.wave.filter.flow;

import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.bouncelets.audio.base.AudioConfig;
import org.corebounce.decklight.bouncelets.audio.base.AudioMath;
import org.corebounce.decklight.bouncelets.audio.base.WaveData;
import org.corebounce.decklight.bouncelets.audio.effect.wave.filter.DjEngine;
import org.corebounce.decklight.bouncelets.audio.ports.InAudio;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;
import org.corebounce.decklight.bridge.ScaleType;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;

public class DjSplitter
extends Bouncelet {
    public InAudio inAudio = new InAudio("in", "Audio input wave");
    public InDouble inLow = new InDouble("level.low", "Low band level [dB]", 0.0, -100.0, 20.0);
    public InDouble inMid = new InDouble("level.mid", "Middle band level [dB]", 0.0, -100.0, 20.0);
    public InDouble inHigh = new InDouble("level.high", "High band level [dB]", 0.0, -100.0, 20.0);
    public InDouble inLowCut = new InDouble("cut.low", "Lowpass cutoff frequency", 600.0, 1.0, AudioConfig.MAX_FREQUENCY);
    public InDouble inHighCut = new InDouble("cut.high", "Highpass cutoff frequency", 2000.0, 1.0, AudioConfig.MAX_FREQUENCY);
    public OutAudio outLow = new OutAudio("out.low", "Low frequencies");
    public OutAudio outMid = new OutAudio("out.mid", "Middle frequencies");
    public OutAudio outHigh = new OutAudio("out.high", "High frequencies");
    private double lowLevel;
    private double midLevel;
    private double highLevel;
    private DjEngine[] engines;

    public DjSplitter() {
        super("audio.effect.wave.filter.flow.djsplit", "Split audio into low, medium and high frequencies");
        super.setSkillType(SkillType.ADVANCED);
        this.inLowCut.setScaleType(ScaleType.LOG2);
        this.inHighCut.setScaleType(ScaleType.LOG2);
    }

    public void cycle() {
        this.setup();
        this.process();
    }

    private void setup() {
        if (this.inLow.isModified()) {
            this.lowLevel = AudioMath.dbToLevel((Double)this.inLow.read());
        }
        if (this.inMid.isModified()) {
            this.midLevel = AudioMath.dbToLevel((Double)this.inMid.read());
        }
        if (this.inHigh.isModified()) {
            this.highLevel = AudioMath.dbToLevel((Double)this.inHigh.read());
        }
        WaveData input = (WaveData)this.inAudio.peek();
        if (this.engines == null || this.engines.length != input.nbChannels || this.inLowCut.isModified() || this.inHighCut.isModified()) {
            this.engines = new DjEngine[input.nbChannels];
            int i = 0;
            while (i < this.engines.length) {
                this.engines[i] = new DjEngine((Double)this.inLowCut.read(), (Double)this.inHighCut.read());
                ++i;
            }
        }
    }

    private void process() {
        WaveData wave = (WaveData)this.inAudio.read();
        this.outLow.prepare(wave.nbChannels, wave.nbFrames, wave.windowing);
        this.outMid.prepare(wave.nbChannels, wave.nbFrames, wave.windowing);
        this.outHigh.prepare(wave.nbChannels, wave.nbFrames, wave.windowing);
        WaveData lowWave = (WaveData)this.outLow.get();
        WaveData midWave = (WaveData)this.outMid.get();
        WaveData highWave = (WaveData)this.outHigh.get();
        int chan = 0;
        while (chan < wave.nbChannels) {
            float[] input = wave.data[chan];
            float[] low = lowWave.data[chan];
            float[] mid = midWave.data[chan];
            float[] high = highWave.data[chan];
            DjEngine engine = this.engines[chan];
            engine.setLowLevel((float)this.lowLevel);
            engine.setMidLevel((float)this.midLevel);
            engine.setHighLevel((float)this.highLevel);
            engine.split(input, low, mid, high);
            ++chan;
        }
    }
}

