/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.wave.pitch;

import org.corebounce.decklight.bouncelets.audio.base.AudioConfig;
import org.corebounce.decklight.bouncelets.audio.base.AudioStateWaveBouncelet;
import org.corebounce.decklight.bouncelets.audio.base.WaveData;
import org.corebounce.decklight.bouncelets.audio.effect.wave.pitch.DetuneEngine;
import org.corebounce.decklight.bouncelets.audio.ports.InAudio;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;
import org.corebounce.decklight.bridge.ScaleType;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InBoolean;
import org.corebounce.decklight.ports.InDouble;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Detune
extends AudioStateWaveBouncelet<DetuneEngine> {
    private static final int STRENGTH = 5;
    public InAudio inAudio = new InAudio("in", "Input Audio Wave");
    public InDouble inShift = new InDouble("shift", "Frequency shift amount [Hz]", 0.0, -1000.0, 1000.0);
    public InBoolean inFilter = new InBoolean("filter", "Filter wrapped frequencies", true);
    public OutAudio outAudio = new OutAudio("out", "Output Audio wave");

    public Detune() {
        super("audio.effect.wave.pitch.detune", "Detune by shifting the frequencies", true);
        super.setSkillType(SkillType.SIMPLIFIED);
        this.inShift.setScaleType(ScaleType.CUBEROOT);
        this.inShift.setSkillType(SkillType.SIMPLIFIED);
    }

    @Override
    public boolean checkForChanges() {
        return this.inFilter.isModified();
    }

    protected DetuneEngine[] createStates(int nbChans) {
        WaveData wave = (WaveData)this.inAudio.peek();
        DetuneEngine[] result = new DetuneEngine[nbChans];
        double shift = (Double)this.inShift.read();
        int i = 0;
        while (i < nbChans) {
            result[i] = new DetuneEngine(AudioConfig.getSampleRate(), wave.nbFrames, 5);
            this.setup(result[i], shift);
            ++i;
        }
        return result;
    }

    @Override
    public void setup(boolean changes) {
        super.setup(changes);
        if (this.inShift.isModified() && this.states != null) {
            double shift = (Double)this.inShift.read();
            int i = 0;
            while (i < ((DetuneEngine[])this.states).length) {
                this.setup(((DetuneEngine[])this.states)[i], shift);
                ++i;
            }
        }
    }

    private void setup(DetuneEngine engine, double shift) {
        engine.setShift(shift);
    }

    @Override
    public void process(DetuneEngine state, float[] input, float[] output) {
        state.process(input, output, (Boolean)this.inFilter.read());
    }
}

