/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.wave.pitch;

import org.corebounce.common.audio.IAudioSource;
import org.corebounce.common.dsp.resample.FastSincResampler;
import org.corebounce.common.dsp.resample.IResampler;
import org.corebounce.common.dsp.resample.LinearResampler;
import org.corebounce.common.dsp.resample.SampleAndHoldResampler;
import org.corebounce.common.dsp.resample.SincResampler;
import org.corebounce.common.dsp.resample.SweepableLinearResampler;
import org.corebounce.common.math.Fraction;
import org.corebounce.decklight.bouncelets.audio.FloatQueue;
import org.corebounce.decklight.bouncelets.audio.base.PowerOf2;
import org.corebounce.decklight.bouncelets.audio.base.WaveData;
import org.corebounce.decklight.bouncelets.audio.effect.VariableRatePullBouncelet;
import org.corebounce.decklight.bouncelets.audio.ports.InAudio;
import org.corebounce.decklight.bouncelets.audio.ports.InPowerOf2;
import org.corebounce.decklight.bridge.ScaleType;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;
import org.corebounce.decklight.ports.InInt;

public class Resample
extends VariableRatePullBouncelet {
    private static final int SINC_UPSAMPLE_FACTOR = 256;
    private static final int SINC_NB_ZERO_CROSS = 13;
    private static final float SINC_KAISER_FACTOR = 80.0f;
    public InAudio inAudio = new InAudio("in", "Input Audio Wave");
    public InDouble inRatio = new InDouble(true, "ratio", "Resampling ratio (Output rate / input rate)", 1.0, 0.25, 4.0);
    public InInt inQuality = new InInt(true, "quality", "Quality", 1, 0, 4);
    public InPowerOf2 inBuffer = new InPowerOf2(true, "buffer", "Buffer size", PowerOf2.p512, PowerOf2.p1, PowerOf2.p524288);
    private Fraction ratio = new Fraction(1L);
    private IResampler[] resamplers;
    private IAudioSource[] audioSources;
    private int preSamples;
    private int bufferSize;

    public Resample() {
        super("audio.effect.wave.pitch.resample", "Resample");
        super.setSkillType(SkillType.SIMPLIFIED);
        this.inRatio.setSkillType(SkillType.SIMPLIFIED);
        this.inRatio.setScaleType(ScaleType.LOG2);
        this.inBuffer.setSkillType(SkillType.EXPERT);
    }

    protected InAudio getInAudio() {
        return this.inAudio;
    }

    protected int getMaxPreSamples(Fraction ratio) {
        this.preSamples = this.bufferSize + 3;
        return this.preSamples;
    }

    protected Fraction getRatio() {
        if (this.inRatio.isModified()) {
            double value = (Double)this.inRatio.read();
            this.ratio = new Fraction().fromDouble(value, 8);
        }
        return this.ratio;
    }

    protected boolean setupRequired() {
        boolean result = this.inBuffer.isModified();
        if (result) {
            this.bufferSize = ((PowerOf2)((Object)this.inBuffer.read())).intValue();
        }
        return result;
    }

    protected void setup(boolean changes) {
        if (changes |= this.inQuality.isModified()) {
            int quality = (Integer)this.inQuality.read();
            this.resamplers = new IResampler[this.nbChans];
            this.audioSources = new IAudioSource[this.nbChans];
            Fraction resampleRatio = Fraction.inverse(this.ratio).seal();
            int chan = 0;
            while (chan < this.nbChans) {
                this.audioSources[chan] = new FloatQueueAudioSource(this.inputQueue[chan]);
                IAudioSource source = this.audioSources[chan];
                switch (quality) {
                    case 0: {
                        this.resamplers[chan] = new SampleAndHoldResampler(source, resampleRatio.doubleValue(), this.bufferSize);
                        break;
                    }
                    case 1: {
                        this.resamplers[chan] = new LinearResampler(source, resampleRatio, this.bufferSize);
                        break;
                    }
                    case 2: {
                        this.resamplers[chan] = new SweepableLinearResampler(source, resampleRatio.doubleValue(), this.bufferSize);
                        break;
                    }
                    case 3: {
                        this.resamplers[chan] = new FastSincResampler(source, resampleRatio.doubleValue(), 256, 13, 80.0f, 1.0f, this.bufferSize);
                        break;
                    }
                    case 4: {
                        this.resamplers[chan] = new SincResampler(source, resampleRatio, 256, 13, 80.0f, 1.0f, this.bufferSize);
                    }
                }
                ++chan;
            }
        }
    }

    protected void process() {
        WaveData dstWave = (WaveData)this.outAudio.get();
        int chan = 0;
        while (chan < this.nbChans) {
            float[] output = dstWave.data[chan];
            IResampler resampler = this.resamplers[chan];
            resampler.resample(output);
            ++chan;
        }
    }

    public int getLatency() {
        return this.nbFrames + this.preSamples;
    }

    static class FloatQueueAudioSource
    implements IAudioSource {
        private final FloatQueue inputQueue;

        public FloatQueueAudioSource(FloatQueue inputQueue) {
            this.inputQueue = inputQueue;
        }

        public int getSamples(float[] target, int offset, int count) {
            this.inputQueue.popArray(target, offset, count);
            return count;
        }
    }
}

