/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.wave.pitch;

import org.corebounce.decklight.bouncelets.audio.effect.wave.filter.FilterEngine;
import org.corebounce.math.FastMath;

public class WeaverEngine {
    private static final double PI2 = Math.PI * 2;
    private static final double PHASE_OFFSET = 1.0;
    private static final float UNITY = (float)(Math.sqrt(8.0) / Math.PI);
    private final double sampleRate;
    private double rate2;
    private final float[] modulator1a;
    private final float[] modulator1b;
    private int index1 = 0;
    private final FilterEngine preFilter;
    private final FilterEngine lowPassA;
    private final FilterEngine lowPassB;
    private double angle2a = 1.0;
    private double angle2b = 2.5707963267948966;
    private float[] bufferA;
    private float[] bufferB;

    public WeaverEngine(double sampleRate, int bufferSize, int filterStrength) {
        this.sampleRate = sampleRate;
        this.setBufferSize(bufferSize);
        this.preFilter = new FilterEngine(filterStrength * 2);
        double cutFrequency = sampleRate / 4.0;
        this.lowPassA = new FilterEngine(filterStrength);
        this.lowPassA.initButterworthLow(sampleRate, cutFrequency);
        this.lowPassB = new FilterEngine(filterStrength);
        this.lowPassB.initButterworthLow(sampleRate, cutFrequency);
        this.modulator1a = new float[4];
        this.modulator1b = new float[4];
        int i = 0;
        while (i < 4) {
            this.modulator1a[i] = (float)FastMath.fastSin(Math.PI * (double)i / 2.0) * UNITY;
            this.modulator1b[i] = (float)FastMath.fastCos(Math.PI * (double)i / 2.0) * UNITY;
            ++i;
        }
    }

    public void setBufferSize(int size) {
        if (this.bufferA == null || this.bufferA.length != size) {
            this.bufferA = new float[size];
            this.bufferB = new float[size];
        }
    }

    public void setShift(double shift) {
        double freq1 = this.sampleRate / 4.0;
        double freq2 = freq1 + shift;
        if (freq2 < 1.0) {
            freq2 = 1.0;
        }
        this.rate2 = Math.PI * 2 * freq2 / this.sampleRate;
        double lower = 15.0 + Math.abs(shift);
        double upper = 22000.0 - Math.abs(shift);
        this.preFilter.initButterworthBand(this.sampleRate, lower, upper);
    }

    public void process(float[] input, float[] output, boolean filter) {
        if (this.bufferA == null || this.bufferB == null) {
            throw new IllegalStateException();
        }
        if (input.length != output.length || input.length != this.bufferA.length) {
            throw new IllegalArgumentException();
        }
        if (filter) {
            this.preFilter(input, output);
        } else {
            System.arraycopy(input, 0, output, 0, input.length);
        }
        this.applyFirstModulation(output);
        this.applyLowpassFilters();
        this.applySecondModulation();
        this.mixIntoOutput(output);
    }

    public void processPreFiltered(float[] buffer) {
        if (this.bufferA == null || this.bufferB == null) {
            throw new IllegalStateException();
        }
        if (buffer.length != buffer.length || buffer.length != this.bufferA.length) {
            throw new IllegalArgumentException();
        }
        this.applyFirstModulation(buffer);
        this.applyLowpassFilters();
        this.applySecondModulation();
        this.mixIntoOutput(buffer);
    }

    public void preFilter(float[] input, float[] output) {
        if (input != output) {
            int i = 0;
            while (i < input.length) {
                output[i] = input[i];
                ++i;
            }
        }
        this.preFilter.processButter(input, output);
    }

    private void applyFirstModulation(float[] buffer) {
        int i = 0;
        while (i < this.bufferA.length) {
            this.bufferA[i] = buffer[i] * this.modulator1a[this.index1];
            this.bufferB[i] = buffer[i] * this.modulator1b[this.index1];
            this.index1 = (this.index1 + 1) % this.modulator1a.length;
            ++i;
        }
    }

    private void applyLowpassFilters() {
        this.lowPassA.processButter(this.bufferA, this.bufferA);
        this.lowPassB.processButter(this.bufferB, this.bufferB);
    }

    private void applySecondModulation() {
        int i = 0;
        while (i < this.bufferA.length) {
            this.bufferA[i] = this.bufferA[i] * (float)FastMath.fastSin0(this.angle2a);
            this.bufferB[i] = this.bufferB[i] * (float)FastMath.fastSin0(this.angle2b);
            this.angle2a += this.rate2;
            if (this.angle2a > Math.PI) {
                this.angle2a -= Math.PI * 2;
            }
            this.angle2b = this.angle2a + 1.5707963267948966;
            if (this.angle2b > Math.PI) {
                this.angle2b -= Math.PI * 2;
            }
            ++i;
        }
    }

    private void mixIntoOutput(float[] output) {
        int i = 0;
        while (i < output.length) {
            output[i] = (this.bufferA[i] + this.bufferB[i]) * 2.0f;
            ++i;
        }
    }
}

