/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.wave.stereo;

import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.bouncelets.audio.base.WaveData;
import org.corebounce.decklight.bouncelets.audio.ports.InAudio;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;

public class Balance
extends Bouncelet {
    public InAudio inAudio = new InAudio("in", "Input audio wave");
    public InDouble inPan = new InDouble("balance", "Balance position, 0=front, +1=right, -1=left, \u00b12=rear", 0.0, -4.0, 4.0);
    public OutAudio outAudio = new OutAudio("out", "Output audio wave");

    public Balance() {
        super("audio.effect.wave.stereo.balance", "Stereo balance");
        super.setSkillType(SkillType.SIMPLIFIED);
        this.inPan.setSkillType(SkillType.SIMPLIFIED);
    }

    public void cycle() {
        boolean phaseReverse;
        WaveData inWave = (WaveData)this.inAudio.read();
        int nbChannels = inWave.nbChannels;
        if (nbChannels < 2) {
            nbChannels = 2;
        }
        this.outAudio.prepare(nbChannels, inWave.nbFrames, inWave.windowing);
        WaveData outWave = (WaveData)this.outAudio.get();
        double pan = (Double)this.inPan.read();
        boolean bl = phaseReverse = Math.abs(pan) > 2.0;
        if (pan > 2.0) {
            pan -= 4.0;
        } else if (pan < -2.0) {
            pan += 4.0;
        }
        float minPanZero = (float)(pan < 0.0 ? pan : 0.0);
        float maxPanZero = (float)(pan > 0.0 ? pan : 0.0);
        float[] input1 = inWave.data[0 % inWave.nbChannels];
        float[] input2 = inWave.data[1 % inWave.nbChannels];
        float[] output1 = outWave.data[0];
        float[] output2 = outWave.data[1];
        int i = 0;
        while (i < outWave.nbFrames) {
            float in1 = input1[i];
            float in2 = input2[i];
            if (phaseReverse) {
                output1[i] = -(1.0f - maxPanZero) * in1;
                output2[i] = -(1.0f + minPanZero) * in2;
            } else {
                output1[i] = (1.0f - maxPanZero) * in1;
                output2[i] = (1.0f + minPanZero) * in2;
            }
            ++i;
        }
        int chan = 2;
        while (chan < outWave.nbChannels) {
            int i2 = 0;
            while (i2 < outWave.nbFrames) {
                outWave.data[chan][i2] = inWave.data[chan][i2];
                ++i2;
            }
            ++chan;
        }
    }
}

