/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.wave.stereo;

import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.bouncelets.audio.base.WaveData;
import org.corebounce.decklight.bouncelets.audio.ports.InAudio;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;

public class Screw
extends Bouncelet {
    private static final float SQRT2 = (float)Math.sqrt(0.5);
    public InAudio inAudio = new InAudio("in", "Input audio wave");
    public OutAudio outAudio = new OutAudio("out", "Output audio wave");

    public Screw() {
        super("audio.effect.wave.stereo.screw", "Convert (Left, Right) <--> (Sum, Diff)");
    }

    public void cycle() {
        WaveData inWave = (WaveData)this.inAudio.read();
        this.outAudio.prepare(inWave.nbChannels, inWave.nbFrames, inWave.windowing);
        WaveData outWave = (WaveData)this.outAudio.get();
        int chan = 0;
        while (chan < inWave.nbChannels) {
            int chan1 = chan;
            int chan2 = chan + 1 >= inWave.nbChannels ? chan1 : chan1 + 1;
            float correction = chan1 == chan2 ? 0.5f : SQRT2;
            float[] input1 = inWave.data[chan1];
            float[] input2 = inWave.data[chan2];
            float[] output1 = outWave.data[chan1];
            float[] output2 = outWave.data[chan2];
            int i = 0;
            while (i < inWave.nbFrames) {
                output2[i] = (input1[i] - input2[i]) * correction;
                output1[i] = (input1[i] + input2[i]) * correction;
                ++i;
            }
            chan += 2;
        }
    }
}

