/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.wave.stereo;

import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.bouncelets.audio.base.WaveData;
import org.corebounce.decklight.bouncelets.audio.ports.InAudio;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;

public class SubChannels
extends Bouncelet {
    public InAudio inAudio = new InAudio("in", "Input stereo audio wave");
    public OutAudio outAudio = new OutAudio("out", "Output mono audio wave");

    public SubChannels() {
        super("audio.effect.wave.stereo.subchannels", "Subtract left and right channels");
    }

    public void cycle() {
        WaveData inWave = (WaveData)this.inAudio.read();
        this.outAudio.prepare(inWave.nbChannels / 2, inWave.nbFrames, inWave.windowing);
        WaveData outWave = (WaveData)this.outAudio.get();
        int chan = 0;
        while (chan < outWave.nbChannels) {
            float[] out = outWave.data[chan];
            float[] left = inWave.data[chan * 2 + 0];
            float[] right = inWave.data[chan * 2 + 1];
            int i = 0;
            while (i < out.length) {
                out[i] = (left[i] - right[i]) / 2.0f;
                ++i;
            }
            ++chan;
        }
    }
}

