/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.effect.wave.time;

import org.corebounce.decklight.bouncelets.audio.Buffer;
import org.corebounce.decklight.bouncelets.audio.base.AudioConfig;
import org.corebounce.decklight.bouncelets.audio.base.AudioStateWaveBouncelet;
import org.corebounce.decklight.bouncelets.audio.effect.wave.time.FlangerState;
import org.corebounce.decklight.bouncelets.audio.ports.InAudio;
import org.corebounce.decklight.bouncelets.audio.ports.InSpectrumPreset;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;
import org.corebounce.decklight.bouncelets.audio.ports.PortValueSetter;
import org.corebounce.decklight.bouncelets.audio.ports.Presetter;
import org.corebounce.decklight.bridge.ScaleType;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InBoolean;
import org.corebounce.decklight.ports.InDouble;
import org.corebounce.math.FastMath;
import org.corebounce.utils.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Flanger
extends AudioStateWaveBouncelet<FlangerState> {
    public InAudio inAudio = new InAudio("in", "Input audio wave");
    public InDouble inRate = new InDouble("period", "Flange period [s]", 4.0, 0.01, 10.0);
    public InDouble inDepth = new InDouble("depth", "Flange depth", -3.0, -5.0, 0.0);
    public InSpectrumPreset<Flanger, Preset> inPreset = new InSpectrumPreset(Preset.class, "Presets", "Predefined settings", Preset.Narrow);
    public InDouble inSkew = new InDouble("skew", "Phase to rate skew", 0.0, -0.99, 0.99);
    public InDouble inStrength = new InDouble("strength", "Wet/Dry ratio", 1.0, 0.0, 1.0);
    public InDouble inPhase = new InDouble("phase", "Initial phase [\u03c0]", 0.0, 0.0, 2.0);
    public InBoolean inTriangle = new InBoolean("triangle", "Use triangular instead of sine variation", false);
    public OutAudio outAudio = new OutAudio("out", "Output audio wave");
    private double rate;
    private double depth;
    private double dryLevel;
    private double wetLevel;
    private double skew;
    private boolean triangular;

    public Flanger() {
        super("audio.effect.wave.time.flanger", "Mix with a delay-varying copy", true);
        super.setSkillType(SkillType.SIMPLIFIED);
        this.inPreset.setSkillType(SkillType.SIMPLIFIED);
        this.inSkew.setSkillType(SkillType.ADVANCED);
        this.inStrength.setSkillType(SkillType.ADVANCED);
        this.inPhase.setSkillType(SkillType.EXPERT);
        this.inRate.setScaleType(ScaleType.LOG2);
    }

    @Override
    public boolean checkForChanges() {
        return this.inDepth.isModified() || this.inPhase.isModified();
    }

    protected FlangerState[] createStates(int nbChans) {
        int historySize = (int)(this.depth * (double)AudioConfig.getSampleRate()) + 1;
        Log.debug("Flanger history size: {0}", historySize);
        FlangerState[] result = new FlangerState[nbChans];
        int i = 0;
        while (i < nbChans) {
            if (this.states != null && i < ((FlangerState[])this.states).length) {
                result[i] = ((FlangerState[])this.states)[i];
                result[i].getBuffer().setSize(historySize);
            } else {
                result[i] = new FlangerState(historySize);
            }
            result[i].setAngle((Double)this.inPhase.read() * Math.PI);
            ++i;
        }
        return result;
    }

    @Override
    public void setup(boolean changes) {
        if (this.inRate.isModified()) {
            this.rate = (Double)this.inRate.read();
        }
        if (this.inDepth.isModified()) {
            this.depth = Math.pow(10.0, (Double)this.inDepth.read());
        }
        if (this.inStrength.isModified()) {
            this.wetLevel = (Double)this.inStrength.read();
            this.dryLevel = 1.0;
            double correction = 1.0 / Math.sqrt(this.wetLevel * this.wetLevel + this.dryLevel * this.dryLevel);
            this.wetLevel *= correction;
            this.dryLevel *= correction;
        }
        if (this.inSkew.isModified()) {
            this.skew = (Double)this.inSkew.read();
        }
        if (this.inTriangle.isModified()) {
            this.triangular = (Boolean)this.inTriangle.read();
        }
    }

    private float getPast(Buffer buffer, float delay, float curSample) {
        int i0 = (int)delay;
        int i1 = i0 + 1;
        float w1 = delay - (float)i0;
        float w0 = 1.0f - w1;
        float s0 = i0 == 0 ? curSample : buffer.getPast(i0);
        float s1 = i1 == 0 ? curSample : buffer.getPast(i1);
        return s0 * w0 + s1 * w1;
    }

    private float tri(double angle) {
        if ((angle -= Math.PI * 2 * FastMath.floor(angle / (Math.PI * 2))) < Math.PI) {
            return (float)(angle * 2.0 / Math.PI);
        }
        return (float)(2.0 - (angle - Math.PI) * 2.0 / Math.PI);
    }

    @Override
    public void process(FlangerState state, float[] input, float[] output) {
        Buffer buffer = state.getBuffer();
        double angle = state.getAngle();
        float smpDepth = (float)this.depth * (float)AudioConfig.getSampleRate() / 2.0f;
        double sampleRate = AudioConfig.getSampleRate();
        assert (input.length == output.length);
        int i = 0;
        while (i < input.length) {
            float delay;
            float curSample = input[i];
            buffer.push(curSample);
            if (this.triangular) {
                delay = this.tri(angle) * smpDepth;
            } else {
                delay = (float)(1.0 - FastMath.fastCos(angle)) * smpDepth;
                if (delay < 0.0f) {
                    delay = 0.0f;
                }
            }
            float mixSample = this.getPast(buffer, delay, curSample);
            output[i] = curSample * (float)this.dryLevel + mixSample * (float)this.wetLevel;
            double phase = this.rate;
            if (this.skew != 0.0) {
                phase = this.rate * (FastMath.fastCos(angle) * this.skew + 1.0);
            }
            angle += Math.PI * 2 / (sampleRate * phase);
            ++i;
        }
        angle -= Math.PI * 2 * FastMath.floor(angle / (Math.PI * 2));
        state.setAngle(angle);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Preset implements Presetter<Flanger>
    {
        Narrow{

            public void apply(Flanger b, PortValueSetter setter) {
                setter.setPortValue(b.inRate, 4.0);
                setter.setPortValue(b.inDepth, -3.0);
                setter.setPortValue(b.inSkew, 0.0);
                setter.setPortValue(b.inStrength, 1.0);
                setter.setPortValue(b.inTriangle, false);
            }
        }
        ,
        Wide{

            public void apply(Flanger b, PortValueSetter setter) {
                setter.setPortValue(b.inRate, 4.0);
                setter.setPortValue(b.inDepth, -2.0);
                setter.setPortValue(b.inSkew, 0.5);
                setter.setPortValue(b.inStrength, 1.0);
                setter.setPortValue(b.inTriangle, false);
            }
        }
        ,
        Bubbles{

            public void apply(Flanger b, PortValueSetter setter) {
                setter.setPortValue(b.inRate, 0.05);
                setter.setPortValue(b.inDepth, -2.0);
                setter.setPortValue(b.inSkew, -0.99);
                setter.setPortValue(b.inStrength, 1.0);
                setter.setPortValue(b.inTriangle, false);
            }
        }
        ,
        MachineGun{

            public void apply(Flanger b, PortValueSetter setter) {
                setter.setPortValue(b.inRate, 0.07);
                setter.setPortValue(b.inDepth, -1.5);
                setter.setPortValue(b.inSkew, 0.99);
                setter.setPortValue(b.inStrength, 1.0);
                setter.setPortValue(b.inTriangle, true);
            }
        };

    }
}

