/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.flow;

import org.corebounce.common.math.Cmplx;
import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.bouncelets.audio.base.SpectrumData;
import org.corebounce.decklight.bouncelets.audio.ports.InSpectrum;
import org.corebounce.decklight.bouncelets.audio.ports.OutSpectrum;
import org.corebounce.decklight.bridge.SkillType;

public class SpectrumPipe
extends Bouncelet {
    public InSpectrum inSpectrum = new InSpectrum("in", "Input audio spectrum");
    public OutSpectrum outSpectrum = new OutSpectrum("out", "Output audio spectrum");

    public SpectrumPipe() {
        super("audio.flow.spectrum-pipe", "Spectrum pipe");
        super.setSkillType(SkillType.ADVANCED);
    }

    public void cycle() {
        SpectrumData inAudio = (SpectrumData)this.inSpectrum.read();
        this.outSpectrum.prepare(inAudio);
        SpectrumData outAudio = (SpectrumData)this.outSpectrum.get();
        int chan = 0;
        while (chan < inAudio.nbChannels) {
            Cmplx[] input = inAudio.data[chan];
            Cmplx[] output = outAudio.data[chan];
            assert (input.length == output.length);
            int i = 0;
            while (i < input.length) {
                output[i].set(input[i]);
                ++i;
            }
            ++chan;
        }
    }
}

