/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.flow;

import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.bouncelets.audio.base.WaveData;
import org.corebounce.decklight.bouncelets.audio.ports.InAudio;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;
import org.corebounce.decklight.bridge.SkillType;

public class WavePipe
extends Bouncelet {
    public InAudio inAudio = new InAudio("in", "Input audio wave");
    public OutAudio outAudio = new OutAudio("out", "Output audio wave");

    public WavePipe() {
        super("audio.flow.wave-pipe", "Audio wave pipe");
        super.setSkillType(SkillType.ADVANCED);
    }

    public void cycle() {
        WaveData inWave = (WaveData)this.inAudio.read();
        this.outAudio.prepare(inWave.nbChannels, inWave.nbFrames, inWave.windowing);
        WaveData outWave = (WaveData)this.outAudio.get();
        int chan = 0;
        while (chan < inWave.nbChannels) {
            float[] input = inWave.data[chan];
            float[] output = outWave.data[chan];
            assert (input.length == output.length);
            int i = 0;
            while (i < input.length) {
                output[i] = input[i];
                ++i;
            }
            ++chan;
        }
    }
}

