/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.line;

import java.util.Arrays;
import org.corebounce.common.math.Fraction;
import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.BounceletPriority;
import org.corebounce.decklight.GraphErrorType;
import org.corebounce.decklight.audio.device.AudioException;
import org.corebounce.decklight.audio.device.AudioIO;
import org.corebounce.decklight.bouncelets.audio.base.AudioConfig;
import org.corebounce.decklight.bouncelets.audio.base.AudioMath;
import org.corebounce.decklight.bouncelets.audio.base.WaveData;
import org.corebounce.decklight.bouncelets.audio.base.WindowInfo;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.play.PlayState;
import org.corebounce.decklight.play.PlayStateBouncelet;
import org.corebounce.decklight.ports.InDouble;
import org.corebounce.decklight.ports.InInt;
import org.corebounce.utils.Severity;

public class AudioIn
extends Bouncelet
implements PlayStateBouncelet {
    static final int DEFAULT_NB_CHANNELS = 2;
    public InInt inDevice = new InInt("device", "Record device num", 0, 0, 8);
    public InInt inChannels = new InInt("channels", "Number of channels", 2, 1, 10);
    public InDouble inStartup = new InDouble("startup", "Min startup time [s]", 0.25, -5.0, 10.0);
    public OutAudio outAudio = new OutAudio("out", "Audio Channel"){

        public void clear() {
        }
    };
    private int blockSize = 0;
    private int buffers = 0;
    private int sampleRate = 0;
    private int deviceNum = 0;
    private int nbChannels = 2;
    private double startupTime = 0.25;
    private PlayState playState = PlayState.STOP;
    private PlayState desiredState = PlayState.STOP;
    private long desiredTime = -1L;
    private AudioIO device = null;
    private boolean opened = false;
    private float[] samples;
    private WindowInfo windowing;
    private boolean isCold = true;
    private int countBeforeStart;

    public AudioIn() {
        super("audio.line.audio-in", "Capture audio from line-in or microphone", true);
        super.setSkillType(SkillType.SIMPLIFIED);
        this.inStartup.setSkillType(SkillType.EXPERT);
        this.inDevice.setSkillType(SkillType.ADVANCED);
    }

    private boolean needsReset() {
        if (this.device == null) {
            return true;
        }
        return this.blockSize != AudioConfig.blockSize() || this.buffers != AudioConfig.getBuffers() || this.sampleRate != AudioConfig.getSampleRate() || this.inChannels.isModified() || this.inDevice.isModified();
    }

    private void resetAudio() {
        this.dispose();
        this.blockSize = AudioConfig.blockSize();
        this.buffers = AudioConfig.getBuffers();
        this.sampleRate = AudioConfig.getSampleRate();
        this.deviceNum = (Integer)this.inDevice.read();
        this.nbChannels = (Integer)this.inChannels.read();
        this.startupTime = (Double)this.inStartup.read();
        this.device = AudioIO.instance();
        try {
            this.device.releasePlayBack();
            this.device.requestCapture(this.deviceNum, this.nbChannels, this.sampleRate, this.blockSize, this.buffers);
            this.opened = true;
        }
        catch (AudioException ex) {
            super.log(GraphErrorType.DeviceError, Severity.Error, "Failed to open audio capture: {0}", ex.getMessage());
        }
        this.samples = new float[this.nbChannels * this.blockSize];
        if (this.isCold) {
            this.countBeforeStart = AudioIn.getCountDown(this.blockSize, this.sampleRate, this.startupTime);
            this.isCold = false;
        }
        super.log(GraphErrorType.Information, Severity.Debug, "Count before start: {0}", this.countBeforeStart);
    }

    public void dispose() {
        if (this.device != null) {
            this.device.releaseCapture();
            this.device = null;
            this.samples = null;
            if (this.playState == PlayState.STOP) {
                this.isCold = true;
            }
        }
        this.opened = false;
    }

    static int getCountDown(int bufferSize, int sampleRate, double startupTime) {
        try {
            String value = System.getProperty("audio.line.startup-time");
            if (value != null) {
                double delay = Double.parseDouble(value);
                return (int)(delay * (double)sampleRate / (double)bufferSize + 0.5);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        int MIN_CYCLES = 5;
        double minTime = startupTime;
        int logBufferSize = AudioMath.log2(bufferSize);
        if (logBufferSize < 8) {
            minTime += (double)(8 - logBufferSize);
        }
        return 5 + (int)((double)sampleRate * minTime / (double)bufferSize);
    }

    public BounceletPriority getPriority() {
        return BounceletPriority.SOURCE;
    }

    public void cycle() {
        if (!this.opened && this.playState == PlayState.STOP && (double)this.desiredTime < 0.0) {
            return;
        }
        this.readSamples();
        this.convertSamples();
        this.handlePlayStateChanges();
    }

    private void readSamples() {
        if (this.isCapturing()) {
            try {
                this.device.record(this.samples, 0, this.samples.length);
            }
            catch (AudioException ex) {
                super.log(GraphErrorType.DeviceError, Severity.Error, "Failed to capture audio: {0}", ex.getMessage());
                this.opened = false;
            }
            if (this.playState != PlayState.PLAY) {
                Arrays.fill(this.samples, 0.0f);
            }
        } else if (this.countBeforeStart > 0) {
            --this.countBeforeStart;
        }
    }

    private void convertSamples() {
        WaveData buffer = null;
        if (this.needsReset()) {
            this.resetAudio();
            this.windowing = WindowInfo.noWindow(this.blockSize);
            this.outAudio.prepare(this.nbChannels, this.blockSize, this.windowing);
            buffer = (WaveData)this.outAudio.get();
        } else {
            buffer = (WaveData)this.outAudio.get();
            buffer.windowing.setWindowModified(false);
            this.outAudio.setModified(true);
        }
        int nbChans = buffer.nbChannels;
        int chan = 0;
        while (chan < nbChans) {
            int j = chan;
            float[] data = buffer.data[chan];
            int i = 0;
            while (i < buffer.nbFrames) {
                data[i] = this.samples[j];
                j += nbChans;
                ++i;
            }
            ++chan;
        }
    }

    private void handlePlayStateChanges() {
        if (this.desiredTime >= 0L && this.getTime() >= this.desiredTime) {
            this.playState = this.desiredState;
            this.desiredTime = -1L;
            if (this.playState == PlayState.STOP) {
                this.dispose();
            }
        }
    }

    public Fraction cycleSpeed() {
        return AudioConfig.blockSizeFraction();
    }

    public boolean isClocking() {
        return this.isCapturing();
    }

    private boolean isCapturing() {
        return this.countBeforeStart <= 0 && this.opened;
    }

    public int getLatency() {
        return AudioConfig.blockSize();
    }

    public boolean isSource() {
        return true;
    }

    public PlayState getPlayState() {
        return this.playState;
    }

    public boolean isReadyToPlay() {
        return this.opened && this.countBeforeStart <= 0;
    }

    public boolean isStopped() {
        return !this.opened;
    }

    public void setPlayState(PlayState state, long when) {
        if (state == this.playState) {
            return;
        }
        if (state == PlayState.PLAY) {
            this.playState = state;
        } else {
            this.desiredState = state;
            this.desiredTime = when;
        }
    }
}

