/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.line;

import java.util.Arrays;
import org.corebounce.common.math.Fraction;
import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.BounceletPriority;
import org.corebounce.decklight.GraphErrorType;
import org.corebounce.decklight.audio.device.AudioException;
import org.corebounce.decklight.audio.device.AudioIO;
import org.corebounce.decklight.bouncelets.audio.base.AudioConfig;
import org.corebounce.decklight.bouncelets.audio.base.WaveData;
import org.corebounce.decklight.bouncelets.audio.line.AudioIn;
import org.corebounce.decklight.bouncelets.audio.ports.InAudio;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.play.PlayState;
import org.corebounce.decklight.play.PlayStateBouncelet;
import org.corebounce.decklight.ports.InDouble;
import org.corebounce.decklight.ports.InInt;
import org.corebounce.decklight.ports.OutDouble;
import org.corebounce.utils.Log;
import org.corebounce.utils.Severity;

public class AudioOut0
extends Bouncelet
implements PlayStateBouncelet {
    private static final boolean DUMP_CPU_USAGE = false;
    static final int DEFAULT_NB_CHANNELS = 2;
    public InAudio inAudio = new InAudio("in", "Audio Input");
    public InDouble inStartup = new InDouble("startup", "Min startup time [s]", 0.25, -5.0, 10.0);
    public InInt inDevice = new InInt("device", "Playback device num", 0, 0, 8);
    public OutDouble outLatency = new OutDouble("latency", "Total latency [s]");
    private int blockSize = 0;
    private int deviceNum = 0;
    private int nbChannels = 0;
    private int sampleRate = 0;
    private double startupTime = 0.25;
    private PlayState playState = PlayState.STOP;
    private PlayState desiredState = PlayState.STOP;
    private long desiredTime = -1L;
    private AudioIO device = null;
    private boolean opened = false;
    private float[] samples;
    private boolean isCold = true;
    private int countBeforeStart;
    private long lastTick;
    private long statsLastTime;
    private double cpuUsageSum;
    private int cpuUsageCount;

    public AudioOut0() {
        super("internal.audioout", "Audio Out", true);
        this.inStartup.setSkillType(SkillType.EXPERT);
        this.inDevice.setSkillType(SkillType.ADVANCED);
    }

    private boolean needsReset(WaveData incommingShit) {
        if (this.device == null) {
            return true;
        }
        if (this.opened && !this.device.isPlaying()) {
            return true;
        }
        return incommingShit.nbChannels != this.nbChannels || incommingShit.nbFrames != this.blockSize || AudioConfig.getSampleRate() != this.sampleRate || this.inDevice.isModified();
    }

    private void reset(WaveData wave) {
        this.dispose();
        this.blockSize = wave.nbFrames;
        this.nbChannels = wave.nbChannels;
        this.sampleRate = AudioConfig.getSampleRate();
        this.startupTime = (Double)this.inStartup.read();
        this.deviceNum = (Integer)this.inDevice.read();
        this.device = AudioIO.instance();
        int buffers = AudioConfig.getBuffers();
        if (buffers == 0) {
            buffers = 2;
        }
        try {
            this.device.requestPlayBack(this.deviceNum, this.nbChannels, this.sampleRate, this.blockSize, buffers);
            this.opened = true;
        }
        catch (AudioException ex) {
            super.log(GraphErrorType.DeviceError, Severity.Error, "Failed to open audio playback: {0}", ex.getMessage());
        }
        this.samples = new float[this.nbChannels * this.blockSize];
        if (this.isCold) {
            this.countBeforeStart = AudioIn.getCountDown(this.blockSize, this.sampleRate, this.startupTime);
            this.isCold = false;
        }
        Log.info("Graph latency: {0} samples = {1} ms", this.getFullMaxLatency(), (double)this.getFullMaxLatency() * 1000.0 / (double)AudioConfig.getSampleRate());
    }

    public void dispose() {
        if (this.device != null) {
            this.device.releasePlayBack();
            this.device = null;
            this.samples = null;
            if (this.playState == PlayState.STOP) {
                this.isCold = true;
            }
        }
        this.opened = false;
    }

    public BounceletPriority getPriority() {
        return BounceletPriority.SINK;
    }

    public void cycle() {
        if (!this.opened && this.playState == PlayState.STOP && (double)this.desiredTime < 0.0) {
            return;
        }
        this.convertSamples();
        this.writeSamples();
        this.handlePlayStateChanges();
    }

    private void convertSamples() {
        WaveData buffer = (WaveData)this.inAudio.read();
        if (this.needsReset(buffer)) {
            this.reset(buffer);
        }
        int nbChans = buffer.nbChannels;
        int chan = 0;
        while (chan < nbChans) {
            int j = chan;
            float[] data = buffer.data[chan];
            int i = 0;
            while (i < buffer.nbFrames) {
                float sample = data[i];
                if (sample > 1.0f) {
                    sample = 1.0f;
                } else if (sample < -1.0f) {
                    sample = -1.0f;
                }
                this.samples[j] = sample;
                j += nbChans;
                ++i;
            }
            ++chan;
        }
    }

    private void writeSamples() {
        if (this.isPlaying()) {
            if (this.playState != PlayState.PLAY) {
                Arrays.fill(this.samples, 0.0f);
            }
            long clock = System.nanoTime();
            long workTime = clock - this.lastTick;
            try {
                this.device.play(this.samples, 0, this.samples.length);
            }
            catch (AudioException ex) {
                super.log(GraphErrorType.DeviceError, Severity.Error, "Failed to play audio: {0}", ex.getMessage());
                this.opened = false;
            }
        } else {
            if (this.countBeforeStart > 0) {
                --this.countBeforeStart;
            }
            this.lastTick = System.nanoTime();
        }
    }

    private void handlePlayStateChanges() {
        if (this.desiredTime >= 0L && this.getTime() >= this.desiredTime) {
            this.playState = this.desiredState;
            this.desiredTime = -1L;
            if (this.playState == PlayState.STOP) {
                this.dispose();
            }
        }
    }

    public Fraction cycleSpeed() {
        return AudioConfig.blockSizeFraction();
    }

    public boolean isClocking() {
        return this.isPlaying();
    }

    private boolean isPlaying() {
        return this.countBeforeStart <= 0 && this.opened;
    }

    public int getLatency() {
        return AudioConfig.blockSize() * (AudioConfig.getBuffers() - 1);
    }

    public boolean isSink() {
        return true;
    }

    public PlayState getPlayState() {
        return this.playState;
    }

    public boolean isReadyToPlay() {
        return this.opened && this.countBeforeStart <= 0;
    }

    public boolean isStopped() {
        return !this.opened;
    }

    public void setPlayState(PlayState state, long when) {
        if (state == this.playState) {
            return;
        }
        if (state == PlayState.PLAY) {
            this.playState = state;
        } else {
            this.desiredState = state;
            this.desiredTime = when;
        }
    }
}

