/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.ports;

import org.corebounce.decklight.bouncelets.audio.base.AudioConfig;
import org.corebounce.decklight.bouncelets.audio.base.SpectrumData;
import org.corebounce.decklight.bouncelets.audio.base.WindowInfo;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InputPort;
import org.corebounce.utils.CacheMap;
import org.corebounce.utils.MultiKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InSpectrum
extends InputPort<SpectrumData> {
    private static CacheMap<MultiKey, SpectrumData> emptySpectrumsCache = new CacheMap();

    public InSpectrum(String name, String description) {
        super(SpectrumData.class, name, description, null, true);
        this.setSkillType(SkillType.SIMPLIFIED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SpectrumData getEmptySpectrum(int nbChannels, int nbBins, WindowInfo windowing) {
        MultiKey key = new MultiKey(nbChannels, nbBins, windowing);
        CacheMap<MultiKey, SpectrumData> cacheMap = emptySpectrumsCache;
        synchronized (cacheMap) {
            SpectrumData result = emptySpectrumsCache.get(key);
            if (result == null) {
                result = new SpectrumData(nbChannels, nbBins, windowing);
                emptySpectrumsCache.put(key, result);
            }
            return result;
        }
    }

    private static SpectrumData getDefaultSpectrum() {
        int blockSize = AudioConfig.blockSize();
        assert (blockSize != 0);
        int channels = 2;
        SpectrumData result = InSpectrum.getEmptySpectrum(channels, blockSize / 2 + 1, null);
        result.windowing.setWindowModified(false);
        return result;
    }

    @Override
    public void reset() {
        this.data = this.data != null ? InSpectrum.getEmptySpectrum(((SpectrumData)this.data).nbChannels, ((SpectrumData)this.data).nbBins, ((SpectrumData)this.data).windowing) : InSpectrum.getDefaultSpectrum();
    }
}

