/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.ports;

import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.bouncelets.audio.base.PowerOf2;
import org.corebounce.decklight.bouncelets.audio.base.WindowType;
import org.corebounce.decklight.bouncelets.audio.ports.PortValueSetter;
import org.corebounce.decklight.bouncelets.audio.ports.Presetter;
import org.corebounce.decklight.ports.InputPort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InSpectrumPreset<B extends Bouncelet, E extends Enum<E>>
extends InputPort<E>
implements PortValueSetter {
    private PortValueSetter portValueSetter;

    public InSpectrumPreset(boolean isSpeedModifier, Class<E> dataType, String name, String description, E defaultValue) {
        super(isSpeedModifier, dataType, name, description, defaultValue);
    }

    public InSpectrumPreset(Class<E> dataType, String name, String description, E defaultValue) {
        super(dataType, name, description, defaultValue);
    }

    @Override
    public void write(E data) {
        super.write(data);
        Bouncelet bouncelet = this.getBouncelet();
        ((Presetter)data).apply(bouncelet, this);
    }

    public void setSpectrumPortValueSetter(PortValueSetter setter) {
        this.portValueSetter = setter;
    }

    @Override
    public void setBlockSize(PowerOf2 blockSize) {
        if (this.portValueSetter != null) {
            this.portValueSetter.setBlockSize(blockSize);
        }
    }

    @Override
    public void setOverlap(PowerOf2 overlap) {
        if (this.portValueSetter != null) {
            this.portValueSetter.setOverlap(overlap);
        }
    }

    @Override
    public void setAnalysisWindow(WindowType window) {
        if (this.portValueSetter != null) {
            this.portValueSetter.setAnalysisWindow(window);
        }
    }

    @Override
    public void setSynthesisWindow(WindowType window) {
        if (this.portValueSetter != null) {
            this.portValueSetter.setSynthesisWindow(window);
        }
    }

    public <T> void setPortValue(InputPort<T> port, T value) {
        if (port.isConnected()) {
            return;
        }
        Bouncelet b = this.getBouncelet();
        b.scheduleSetPortValue(port, value);
    }
}

