/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.ports;

import org.corebounce.decklight.bouncelets.audio.base.PowerOf2;
import org.corebounce.decklight.bouncelets.audio.base.SpectrumData;
import org.corebounce.decklight.bouncelets.audio.base.WaveData;
import org.corebounce.decklight.bouncelets.audio.base.WindowInfo;
import org.corebounce.decklight.bouncelets.audio.convert.format.asharp.HqxMode;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.StructOutputPort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutSpectrum
extends StructOutputPort<SpectrumData> {
    public OutSpectrum(String name, String description) {
        super(SpectrumData.class, name, description);
        this.setSkillType(SkillType.SIMPLIFIED);
    }

    public boolean prepare(WaveData input) {
        return this.prepare(input, input.windowing);
    }

    public boolean prepare(WaveData input, WindowInfo windowing) {
        return this.prepare(input.nbChannels, input.getNbBins(PowerOf2.p1), 1, null, windowing);
    }

    public boolean prepare(SpectrumData input) {
        return this.prepare(input, input.windowing);
    }

    public boolean prepare(SpectrumData input, WindowInfo windowing) {
        return this.prepare(input.nbChannels, input.nbBins, input.nbLayers, input.hqxMode, windowing);
    }

    public boolean prepare(int nbChannels, int nbBins, int nbLayers, HqxMode hqxMode, WindowInfo windowing) {
        this.setModified(true);
        boolean result = false;
        if (this.data == null || ((SpectrumData)this.data).nbChannels != nbChannels || ((SpectrumData)this.data).nbBins != nbBins) {
            this.data = new SpectrumData(nbChannels, nbBins);
            result = true;
        }
        ((SpectrumData)this.data).nbLayers = nbLayers;
        ((SpectrumData)this.data).hqxMode = hqxMode;
        if (windowing != null) {
            ((SpectrumData)this.data).windowing = windowing;
        }
        return result;
    }
}

