/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.synth.wave;

import org.corebounce.decklight.bouncelets.audio.base.AudioMath;
import org.corebounce.decklight.bouncelets.audio.synth.wave.WaveGeneratorBouncelet;
import org.corebounce.decklight.bridge.ScaleType;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InBoolean;
import org.corebounce.decklight.ports.InDouble;

public abstract class PeriodicWave
extends WaveGeneratorBouncelet {
    public InDouble inFrequency = new InDouble("frequency", "Tone frequency [Hz]", 440.0, 16.0, 22050.0);
    public InDouble inAmplitude = new InDouble("amplitude", "Amplitude [dB]", 0.0, -100.0, 20.0);
    public InDouble inSkew = new InDouble("skew", "Phase skew", 0.5, 0.0, 1.0);
    public InDouble inOffset = new InDouble("offset", "DC offset", 0.0, -1.0, 1.0);
    public InDouble inPhase = new InDouble("startphase", "Start phase [rad]", 0.0, 0.0, Math.PI * 2);
    public InBoolean inActive = new InBoolean("active", "Produce sound?", true);
    private double angle = 0.0;
    private double period;
    private double skewPoint = 0.0;
    private double level;
    private double offset;
    private boolean active = false;

    public PeriodicWave(String name, String description, String outDescription) {
        super(name, description, outDescription);
        this.inFrequency.setScaleType(ScaleType.LOG2);
        this.inFrequency.setSkillType(SkillType.SIMPLIFIED);
        this.inFrequency.setSkillType(SkillType.SIMPLIFIED);
        this.inOffset.setSkillType(SkillType.ADVANCED);
        this.inPhase.setSkillType(SkillType.ADVANCED);
    }

    public void generate(float[] samples, float sampleRate) {
        boolean requestActive = (Boolean)this.inActive.peek();
        if (!this.active && !requestActive) {
            super.generateSilence(samples);
            return;
        }
        if (!this.active && requestActive) {
            this.angle = (Double)this.inPhase.read();
            this.active = true;
        }
        if (this.inAmplitude.isModified()) {
            this.level = AudioMath.dbToLevel((Double)this.inAmplitude.read());
        }
        if (this.inOffset.isModified()) {
            this.offset = (Double)this.inOffset.read();
        }
        if (this.inFrequency.isModified()) {
            this.period = (Double)this.inFrequency.read() / (double)sampleRate;
        }
        if (this.inSkew.isModified()) {
            this.skewPoint = (Double)this.inSkew.read();
        }
        int i = 0;
        while (i < samples.length) {
            double value = this.waveFunction(this.skew(this.angle, this.skewPoint), this.skew(this.wrap(this.angle + this.period), this.skewPoint));
            samples[i] = (float)(value * this.level + this.offset);
            this.angle += this.period;
            if (this.angle >= 1.0) {
                this.angle -= 1.0;
                if (!requestActive) {
                    this.active = false;
                    while (i < samples.length) {
                        samples[i++] = 0.0f;
                    }
                    return;
                }
            }
            ++i;
        }
    }

    private double wrap(double angle) {
        if (angle >= 1.0) {
            angle -= 1.0;
        }
        return angle;
    }

    protected abstract double waveFunction(double var1, double var3);
}

