/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.synth.wave;

import java.util.Random;
import org.corebounce.decklight.bouncelets.audio.base.PowerOf2;
import org.corebounce.decklight.bouncelets.audio.ports.InPowerOf2;
import org.corebounce.decklight.bouncelets.audio.synth.wave.PeriodicWave;
import org.corebounce.decklight.bridge.SkillType;

public class Pluck
extends PeriodicWave {
    public InPowerOf2 inResolution = new InPowerOf2(false, "resolution", "Sampling resolution", PowerOf2.p64);
    private float[] buffer;

    public Pluck() {
        super("audio.synth.wave.pluck", "Generate tone with random harmonics", "Pluck");
        this.inResolution.setSkillType(SkillType.ADVANCED);
    }

    public void cycle() {
        if (this.inResolution.isModified()) {
            Random rnd = new Random();
            this.buffer = new float[((PowerOf2)((Object)this.inResolution.read())).intValue()];
            int i = 0;
            while (i < this.buffer.length) {
                this.buffer[i] = rnd.nextFloat();
                ++i;
            }
        }
        super.cycle();
    }

    protected double waveFunction(double prevAngle, double nextAngle) {
        return this.valueAt((prevAngle + nextAngle) / 2.0);
    }

    private double valueAt(double angle) {
        double index = angle * (double)this.buffer.length;
        int index0 = (int)Math.floor(index);
        int index1 = index0 + 1;
        double weight0 = index - (double)index0;
        double weight1 = 1.0 - weight0;
        return this.buffer[index0 % this.buffer.length] * (float)weight0 + this.buffer[index1 % this.buffer.length] * (float)weight1;
    }
}

