/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.synth.wave;

import org.corebounce.decklight.bouncelets.audio.synth.wave.PeriodicWave;

public class Square
extends PeriodicWave {
    public Square() {
        super("audio.synth.wave.square", "Generate a square wave", "Square wave");
    }

    protected double waveFunction(double prevAngle, double nextAngle) {
        if (nextAngle < 0.5) {
            return -1.0;
        }
        if (nextAngle >= 0.5 && prevAngle < 0.5) {
            double prevWeight = 0.5 - prevAngle;
            double nextWeight = nextAngle - 0.5;
            double total = nextAngle - prevAngle;
            return (-1.0 * prevWeight + 1.0 * nextWeight) / total;
        }
        if (nextAngle < 0.5 && prevAngle >= 0.5) {
            double prevWeight = 1.0 - prevAngle;
            double nextWeight = nextAngle;
            double total = nextAngle + 1.0 - prevAngle;
            return (1.0 * prevWeight - 1.0 * nextWeight) / total;
        }
        return 1.0;
    }
}

