/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.synth.wave;

import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.bouncelets.audio.base.AudioConfig;
import org.corebounce.decklight.bouncelets.audio.base.WaveData;
import org.corebounce.decklight.bouncelets.audio.base.WindowInfo;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;

public abstract class WaveGeneratorBouncelet
extends Bouncelet {
    public OutAudio outAudio;
    private int nbFrames;
    private WindowInfo noWindow;

    public WaveGeneratorBouncelet(String name, String description, String outDescription) {
        super(name, description);
        this.outAudio = new OutAudio("out", outDescription);
    }

    public void cycle() {
        int nbFrames = AudioConfig.blockSize();
        assert (nbFrames != 0);
        if (this.nbFrames != nbFrames) {
            int oldValue = this.nbFrames;
            this.nbFrames = nbFrames;
            this.noWindow = WindowInfo.noWindow(nbFrames);
            this.nbFramesChanged(oldValue, nbFrames);
        }
        this.outAudio.prepare(1, nbFrames, this.noWindow);
        WaveData wave = (WaveData)this.outAudio.get();
        this.generate(wave.data[0], AudioConfig.getSampleRate());
    }

    protected void nbFramesChanged(int oldValue, int newValue) {
    }

    protected final double skew(double angle, double skewPoint) {
        if (angle < skewPoint) {
            if (skewPoint > 0.0) {
                return angle * 0.5 / skewPoint;
            }
            return 0.0;
        }
        if (skewPoint < 1.0) {
            return skewPoint + (angle - skewPoint) * 0.5 / (1.0 - skewPoint);
        }
        return 0.0;
    }

    protected final void generateSilence(float[] samples) {
        int i = 0;
        while (i < samples.length) {
            samples[i] = 0.0f;
            ++i;
        }
    }

    public abstract void generate(float[] var1, float var2);

    public boolean isSource() {
        return true;
    }
}

