/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.synth.wave;

import java.util.Random;
import org.corebounce.decklight.bouncelets.audio.synth.wave.WaveGeneratorBouncelet;
import org.corebounce.decklight.ports.InputPort;

public class WhiteNoise
extends WaveGeneratorBouncelet {
    public InputPort<PdfType> inPdfType = new InputPort<PdfType>(PdfType.class, "Distribution (pdf)", "Probability density function to use for noise", PdfType.TRIANGULAR);
    private final Random rnd = new Random();

    public WhiteNoise() {
        super("audio.synth.wave.whitenoise", "Generate white noise", "White noise");
    }

    public void generate(float[] samples, float sampleRate) {
        PdfType pdfType = this.inPdfType.read();
        int i = 0;
        while (i < samples.length) {
            samples[i] = pdfType.next(this.rnd);
            ++i;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PdfType {
        RECTANGULAR{

            public float next(Random rnd) {
                return rnd.nextFloat() - 0.5f;
            }
        }
        ,
        TRIANGULAR{

            public float next(Random rnd) {
                return rnd.nextFloat() + rnd.nextFloat() - 1.0f;
            }
        }
        ,
        GAUSSIAN{

            public float next(Random rnd) {
                double result;
                while ((result = rnd.nextGaussian() * 0.25) < -1.0 || result > 1.0) {
                }
                return (float)result;
            }
        };


        public abstract float next(Random var1);
    }
}

