/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.synth.wave;

import java.util.Random;
import org.corebounce.decklight.bouncelets.audio.base.AudioConfig;
import org.corebounce.decklight.bouncelets.audio.effect.wave.filter.FilterEngine;
import org.corebounce.decklight.bouncelets.audio.synth.wave.WaveGeneratorBouncelet;
import org.corebounce.decklight.bridge.ScaleType;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;
import org.corebounce.decklight.ports.InInt;
import org.corebounce.decklight.ports.InputPort;

public class Wind
extends WaveGeneratorBouncelet {
    public InputPort<PdfType> inPdfType = new InputPort<PdfType>(PdfType.class, "Distribution (pdf)", "Probability density function to use for noise", PdfType.TRIANGULAR);
    public InDouble inFrequency = new InDouble("center", "Center frequency [Hz]", 440.0, 1.0, AudioConfig.MAX_FREQUENCY);
    public InDouble inWidth = new InDouble("bandwidth", "Band width [Hz]", 1000.0, 1.0, 22000.0);
    public InInt inStrength = new InInt("strength", "Filter strength", 4, 1, 10);
    public InDouble inRipple = new InDouble("ripple", "Pass-band ripple (Chebyshev1) [dB]", 1.0, 0.0, 10.0);
    private final Random rnd = new Random();
    private FilterEngine filter;

    public Wind() {
        super("audio.synth.wave.wind", "Generate band-filtered white noise", "Wind");
        this.inPdfType.setSkillType(SkillType.ADVANCED);
        this.inFrequency.setScaleType(ScaleType.LOG2);
        this.inWidth.setScaleType(ScaleType.CUBEROOT);
        this.inStrength.setSkillType(SkillType.ADVANCED);
        this.inRipple.setSkillType(SkillType.ADVANCED);
    }

    private void setup() {
        if (this.inFrequency.isModified() || this.inWidth.isModified() || this.inStrength.isModified() || this.inRipple.isModified()) {
            double highCut;
            double frequency = (Double)this.inFrequency.read();
            double width = (Double)this.inWidth.read();
            int strength = (Integer)this.inStrength.read();
            double ripple = (Double)this.inRipple.read();
            double lowCut = frequency - width / 2.0;
            if (lowCut < 20.0) {
                lowCut = 20.0;
            }
            if ((highCut = frequency + width / 2.0) > AudioConfig.MAX_FREQUENCY) {
                highCut = AudioConfig.MAX_FREQUENCY;
            }
            if (this.filter == null || this.filter.getNbSections() != strength * 2) {
                this.filter = new FilterEngine(strength * 2);
            }
            this.filter.initChebyshev1Band(AudioConfig.getSampleRate(), lowCut, highCut, ripple);
        }
    }

    public void generate(float[] samples, float sampleRate) {
        this.setup();
        PdfType pdfType = this.inPdfType.read();
        int i = 0;
        while (i < samples.length) {
            samples[i] = pdfType.next(this.rnd);
            ++i;
        }
        this.filter.process(samples, samples);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PdfType {
        RECTANGULAR{

            public float next(Random rnd) {
                return rnd.nextFloat() - 0.5f;
            }
        }
        ,
        TRIANGULAR{

            public float next(Random rnd) {
                return rnd.nextFloat() + rnd.nextFloat() - 1.0f;
            }
        }
        ,
        GAUSSIAN{

            public float next(Random rnd) {
                double result;
                while ((result = rnd.nextGaussian() * 0.25) < -1.0 || result > 1.0) {
                }
                return (float)result;
            }
        };


        public abstract float next(Random var1);
    }
}

