/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.music;

import java.util.Arrays;
import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.bouncelets.audio.base.AudioConfig;
import org.corebounce.decklight.bouncelets.audio.base.WaveData;
import org.corebounce.decklight.bouncelets.audio.base.WindowInfo;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;
import org.corebounce.decklight.bouncelets.music.Tone;
import org.corebounce.decklight.bouncelets.music.ports.InTone;
import org.corebounce.decklight.bridge.ScaleType;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;
import org.corebounce.decklight.ports.InInt;

public class PlayTone
extends Bouncelet {
    public InTone inTone = new InTone("tone", "The tone to play");
    public InDouble inFrequency = new InDouble("frequency", "Playback frequency [Hz]", 165.0, 20.0, 20000.0);
    public InInt inChannels = new InInt("channels", "Number of channels", 2, 1, 8);
    public OutAudio outAudio = new OutAudio("out", "Output audio wave");
    private int nbFrames;
    private int nbChannels;
    private WindowInfo noWindow;
    private double toneTime = 0.0;

    public PlayTone() {
        super("music.play-tone", "Play a tone at a given frequency");
        this.inTone.setSkillType(SkillType.SIMPLIFIED);
        this.inFrequency.setSkillType(SkillType.SIMPLIFIED);
        this.inFrequency.setScaleType(ScaleType.LOG2);
        this.inChannels.setSkillType(SkillType.ADVANCED);
    }

    protected void reset() {
        super.reset();
        this.toneTime = 0.0;
    }

    public void cycle() {
        this.prepare();
        this.generate();
    }

    private void prepare() {
        int nbFrames = AudioConfig.blockSize();
        assert (nbFrames != 0);
        if (this.nbFrames != nbFrames) {
            this.nbFrames = nbFrames;
            this.noWindow = WindowInfo.noWindow(nbFrames);
        }
        if (this.inChannels.isModified()) {
            this.nbChannels = (Integer)this.inChannels.read();
        }
        this.outAudio.prepare(this.nbChannels, nbFrames, this.noWindow);
    }

    private void generate() {
        Tone tone = (Tone)this.inTone.read();
        if (tone == null) {
            return;
        }
        double frequency = (Double)this.inFrequency.read();
        WaveData wave = (WaveData)this.outAudio.get();
        float[] output = wave.data[0];
        Arrays.fill(output, 0.0f);
        double sampleDuration = 1.0 / (double)AudioConfig.getSampleRate();
        double tickDuration = sampleDuration * frequency / 440.0;
        int i = 0;
        while (i < output.length) {
            double sample = tone.getSample(-1.0, this.toneTime, this.toneTime + tickDuration);
            output[i] = (float)sample;
            this.toneTime += tickDuration;
            ++i;
        }
        int chan = 1;
        while (chan < this.nbChannels) {
            float[] otherChan = wave.data[chan];
            System.arraycopy(output, 0, otherChan, 0, output.length);
            ++chan;
        }
    }
}

