/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.music.amplitude;

import org.corebounce.decklight.bouncelets.music.AmCurve;
import org.corebounce.decklight.bouncelets.music.amplitude.AmCurveWrapper;
import org.corebounce.decklight.bouncelets.music.amplitude.AmEffect;
import org.corebounce.decklight.bridge.ScaleType;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;

public class Enveloppe
extends AmEffect {
    public InDouble inAttack = new InDouble("attack", "Attack [s]", 0.005, 0.0, 10.0);
    public InDouble inDecay = new InDouble("decay", "Decay [s]", 0.1, 0.0, 10.0);
    public InDouble inSustain = new InDouble("sustain", "Sustain level [%/100]", 0.7, 0.0, 1.0);
    public InDouble inRelease = new InDouble("release", "Release [s]", 1.5, 0.0, 50.0);

    public Enveloppe() {
        super("music.amplitude.enveloppe", "Generates an Attack-Decay-Sustain-Release enveloppe around notes");
        this.inAttack.setScaleType(ScaleType.LOG2);
        this.inDecay.setScaleType(ScaleType.LOG2);
        this.inRelease.setScaleType(ScaleType.LOG2);
        this.inAttack.setSkillType(SkillType.SIMPLIFIED);
        this.inDecay.setSkillType(SkillType.SIMPLIFIED);
        this.inSustain.setSkillType(SkillType.SIMPLIFIED);
        this.inRelease.setSkillType(SkillType.SIMPLIFIED);
    }

    protected boolean isModified() {
        return this.inAttack.isModified() || this.inDecay.isModified() || this.inSustain.isModified() || this.inRelease.isModified();
    }

    protected void updateParameters() {
    }

    protected AmCurve createTranform(AmCurve source) {
        return new AmCurveWrapper(source){

            public double getAmplitude(double offTime, double time) {
                double curve = Enveloppe.this.getCurve(offTime, time);
                if (curve != 0.0) {
                    return this.source.getAmplitude(offTime, time) * curve;
                }
                return 0.0;
            }
        };
    }

    private double getCurve(double offTime, double time) {
        boolean isOn;
        boolean bl = isOn = offTime < 0.0;
        if (isOn) {
            double attack = (Double)this.inAttack.read();
            double decay = (Double)this.inDecay.read();
            if (time <= attack) {
                return time / attack;
            }
            if (time <= decay) {
                double fall = 1.0 - (Double)this.inSustain.read();
                return 1.0 - (time - attack) / decay * fall;
            }
            return (Double)this.inSustain.read();
        }
        time -= offTime;
        double release = (Double)this.inRelease.read();
        double sustain = (Double)this.inSustain.read();
        if (time < release) {
            return sustain * (1.0 - time / release);
        }
        return 0.0;
    }
}

