/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.music.effect;

import org.corebounce.decklight.bouncelets.audio.base.AudioMath;
import org.corebounce.decklight.bouncelets.music.Tone;
import org.corebounce.decklight.bouncelets.music.effect.DualToneEffect;

public abstract class DualToneWrapper
extends Tone {
    protected final DualToneEffect effect;
    protected final Tone source1;
    protected final Tone source2;

    public DualToneWrapper(DualToneEffect effect, Tone source1, Tone source2) {
        this.effect = effect;
        this.source1 = source1;
        this.source2 = source2;
    }

    public double getPeriod() {
        double period1 = this.source1.getPeriod();
        double period2 = this.source2.getPeriod();
        double common = AudioMath.gcd(period1, period2);
        return period1 * period2 / common;
    }

    public double getLastChangeTime() {
        return this.max(this.source1.getLastChangeTime(), this.source2.getLastChangeTime(), this.effect.getLastChangeTime());
    }
}

