/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.music.effect;

import org.corebounce.decklight.bouncelets.music.Tone;
import org.corebounce.utils.Log;

public class FmEngine {
    private final int resolution;
    private final double depth;
    private final float[] shifts;
    private double lastChangeTime = -1.0;

    public FmEngine(int resolution, double depth) {
        this.resolution = resolution;
        this.depth = depth;
        this.shifts = new float[resolution];
    }

    public void update(Tone source) {
        if (source == null || source.getLastChangeTime() <= this.lastChangeTime) {
            return;
        }
        this.lastChangeTime = source.getLastChangeTime();
        double[] ratios = new double[this.resolution];
        double period = source.getPeriod();
        double incr = period / (double)this.resolution;
        int i = 0;
        while (i < this.resolution) {
            double time = (double)i * incr;
            double value = source.getSample(-1.0, time, time + incr);
            ratios[i] = value = Math.pow(this.depth, value);
            ++i;
        }
        double step = 1.0 / (double)this.resolution;
        double linear = 0.0;
        double modulated = 0.0;
        int i2 = 0;
        while (i2 < this.resolution) {
            this.shifts[i2] = (float)((modulated += step * ratios[i2]) - (linear += step));
            ++i2;
        }
        Log.debug("FM cache updated. Linear {0}, modulated {1}.", linear, modulated);
    }

    public float getShift(int index) {
        return this.shifts[index];
    }
}

