/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.music.effect;

import org.corebounce.decklight.bouncelets.music.Tone;
import org.corebounce.decklight.bouncelets.music.effect.ToneEffect;
import org.corebounce.decklight.bouncelets.music.effect.ToneWrapper;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InInt;

public class FractionRate
extends ToneEffect {
    public InInt inNumerator = new InInt("num", "Numerator of fractional ratio", 10, 1, 200);
    public InInt inDenominator = new InInt("denom", "Denominator of fractional ratio", 10, 1, 200);
    private double ratio;

    public FractionRate() {
        super("music.effect.frate", "Change the rate of a tone by a fractional ratio");
        this.inNumerator.setSkillType(SkillType.SIMPLIFIED);
        this.inDenominator.setSkillType(SkillType.SIMPLIFIED);
    }

    protected boolean isModified() {
        return this.inNumerator.isModified() || this.inDenominator.isModified();
    }

    protected void updateParameters() {
        this.ratio = (double)((Integer)this.inNumerator.read()).intValue() / (double)((Integer)this.inDenominator.read()).intValue();
    }

    protected Tone createTranform(Tone source) {
        return new ToneWrapper(this, source){

            public double getSample(double offTime, double begTime, double endTime) {
                return this.source.getSample(offTime * FractionRate.this.ratio, begTime * FractionRate.this.ratio, endTime * FractionRate.this.ratio);
            }

            public double getPeriod() {
                return super.getPeriod() / FractionRate.this.ratio;
            }
        };
    }
}

