/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.music.effect;

import org.corebounce.decklight.bouncelets.audio.base.PowerOf2;
import org.corebounce.decklight.bouncelets.audio.ports.InPowerOf2;
import org.corebounce.decklight.bouncelets.music.Tone;
import org.corebounce.decklight.bouncelets.music.effect.DualToneEffect;
import org.corebounce.decklight.bouncelets.music.effect.DualToneWrapper;
import org.corebounce.decklight.bouncelets.music.effect.FmEngine;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;

public class FrequencyModulation
extends DualToneEffect {
    private static final double MAX_DEPTH = 5.0;
    public InDouble inDepth = new InDouble("depth", "Modulation depth", 3.0, 0.0, 5.0);
    public InPowerOf2 inResolution = new InPowerOf2(false, "resolution", "Sampling resolution of modulator", PowerOf2.p32);
    private FmEngine cache;
    private int resolution;

    public FrequencyModulation() {
        super("music.effect.fm", "Frequency modulation of first tone by second tone");
        this.inDepth.setSkillType(SkillType.SIMPLIFIED);
        this.inResolution.setSkillType(SkillType.EXPERT);
    }

    protected boolean isModified() {
        return false;
    }

    protected boolean isToneModified() {
        return super.isToneModified() || this.inResolution.isModified() || this.inDepth.isModified();
    }

    protected void updateParameters() {
    }

    public void cycle() {
        if (this.cache != null) {
            this.cache.update((Tone)this.inTone2.peek());
        }
        super.cycle();
    }

    protected Tone createTranform(Tone source1, Tone source2) {
        this.resolution = ((PowerOf2)((Object)this.inResolution.read())).intValue();
        double depth = 1.0 + Math.pow(0.1, 5.0 - (Double)this.inDepth.read());
        this.cache = new FmEngine(this.resolution, depth);
        this.cache.update(source2);
        return new DualToneWrapper(this, source1, source2){

            public double getSample(double offTime, double begTime, double endTime) {
                double modPeriod = this.source2.getPeriod();
                double begPhase = begTime % modPeriod;
                double resBegTime = begTime + this.getShift(begPhase, modPeriod);
                double endPhase = endTime % modPeriod;
                double resEndTime = endTime + this.getShift(endPhase, modPeriod);
                if (resEndTime < resBegTime) {
                    double temp = resEndTime;
                    resEndTime = resBegTime;
                    resBegTime = temp;
                }
                return this.source1.getSample(offTime, resBegTime, resEndTime);
            }

            private double getShift(double phase, double period) {
                if (!$assertionsDisabled && !(phase < period + 1.0E-8)) {
                    throw new AssertionError();
                }
                int index = (int)((double)FrequencyModulation.this.resolution * phase / period) % FrequencyModulation.this.resolution;
                return FrequencyModulation.this.cache.getShift(index);
            }
        };
    }
}

