/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.music.effect;

import org.corebounce.decklight.GraphErrorType;
import org.corebounce.decklight.bouncelets.audio.base.AudioMath;
import org.corebounce.decklight.bouncelets.music.Tone;
import org.corebounce.decklight.bouncelets.music.effect.ToneEffect;
import org.corebounce.decklight.bouncelets.music.effect.ToneWrapper;
import org.corebounce.decklight.bridge.ScaleType;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;
import org.corebounce.utils.Severity;

public class GongOfFour
extends ToneEffect {
    public InDouble inRatio1 = new InDouble("ratio1", "First ratio", 1.006, 0.8, 1.25);
    public InDouble inRatio2 = new InDouble("ratio2", "Second ratio", 1.01, 0.8, 1.25);
    public InDouble inRatio3 = new InDouble("ratio3", "Third ratio", 1.014, 0.8, 1.25);
    private double ratio1;
    private double ratio2;
    private double ratio3;
    private double cycles;

    public GongOfFour() {
        super("music.effect.gongof4", "Musical design pattern ;-)");
        this.inRatio1.setScaleType(ScaleType.CUBEROOT);
        this.inRatio2.setScaleType(ScaleType.CUBEROOT);
        this.inRatio3.setScaleType(ScaleType.CUBEROOT);
        this.inRatio1.setSkillType(SkillType.SIMPLIFIED);
        this.inRatio2.setSkillType(SkillType.SIMPLIFIED);
        this.inRatio3.setSkillType(SkillType.SIMPLIFIED);
    }

    protected boolean isModified() {
        return this.inRatio1.isModified() || this.inRatio2.isModified() || this.inRatio3.isModified();
    }

    protected void updateParameters() {
        this.ratio1 = (Double)this.inRatio1.read();
        this.ratio2 = (Double)this.inRatio2.read();
        this.ratio3 = (Double)this.inRatio3.read();
        this.cycles = (int)(1.0 / AudioMath.gcd(1.0, this.ratio1, this.ratio2, this.ratio3));
        this.log(GraphErrorType.Information, Severity.Debug, "*** Cycles: " + this.cycles, new Object[0]);
    }

    protected Tone createTranform(Tone source) {
        return new ToneWrapper(this, source){

            public double getSample(double offTime, double begTime, double endTime) {
                double s0 = this.source.getSample(offTime, begTime, endTime);
                double s1 = this.source.getSample(offTime * GongOfFour.this.ratio1, begTime * GongOfFour.this.ratio1, endTime * GongOfFour.this.ratio1);
                double s2 = this.source.getSample(offTime * GongOfFour.this.ratio2, begTime * GongOfFour.this.ratio2, endTime * GongOfFour.this.ratio2);
                double s3 = this.source.getSample(offTime * GongOfFour.this.ratio3, begTime * GongOfFour.this.ratio3, endTime * GongOfFour.this.ratio3);
                return (s0 + s1 + s2 + s3) / 4.0;
            }

            public double getPeriod() {
                return this.source.getPeriod() * GongOfFour.this.cycles;
            }
        };
    }
}

