/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.music.effect;

import org.corebounce.decklight.bouncelets.audio.base.AudioMath;
import org.corebounce.decklight.bouncelets.music.Tone;
import org.corebounce.decklight.bouncelets.music.effect.ToneEffect;
import org.corebounce.decklight.bouncelets.music.effect.ToneWrapper;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;

public class Harmony
extends ToneEffect {
    public InDouble inLevel0 = new InDouble("level0", "Level of base frequency", 0.0, -100.0, 20.0);
    public InDouble inLevel1 = new InDouble("level1", "Level of 1st harmonic", -12.0, -100.0, 20.0);
    public InDouble inLevel2 = new InDouble("level2", "Level of 2nd harmonic", -6.0, -100.0, 20.0);
    public InDouble inLevel3 = new InDouble("level3", "Level of 3rd harmonic", -24.0, -100.0, 20.0);
    public InDouble inLevel4 = new InDouble("level4", "Level of 4th harmonic", -12.0, -100.0, 20.0);
    public InDouble inLevel5 = new InDouble("level5", "Level of 5th harmonic", -36.0, -100.0, 20.0);
    public InDouble inLevel6 = new InDouble("level6", "Level of 6th harmonic", -18.0, -100.0, 20.0);
    public InDouble inLevel7 = new InDouble("level7", "Level of 7th harmonic", -48.0, -100.0, 20.0);
    private InDouble[] inLevels = new InDouble[]{this.inLevel0, this.inLevel1, this.inLevel2, this.inLevel3, this.inLevel4, this.inLevel5, this.inLevel6, this.inLevel7};
    private double[] gains = new double[this.inLevels.length];
    private double correction = 0.0;

    public Harmony() {
        super("music.effect.harmony", "Add up to 7 harmonics");
        int i = 0;
        while (i < 4) {
            this.inLevels[i].setSkillType(SkillType.SIMPLIFIED);
            ++i;
        }
    }

    protected boolean isModified() {
        int i = 0;
        while (i < this.inLevels.length) {
            if (this.inLevels[i].isModified()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void updateParameters() {
        int i = 0;
        while (i < this.gains.length) {
            if (this.inLevels[i].isModified()) {
                double level = (Double)this.inLevels[i].read();
                this.gains[i] = AudioMath.dbToLevel(level);
            }
            ++i;
        }
        double sum = 0.0;
        int i2 = 0;
        while (i2 < this.gains.length) {
            sum += this.gains[i2];
            ++i2;
        }
        this.correction = sum > 1.0 ? 1.0 / sum : 1.0;
    }

    protected Tone createTranform(Tone source) {
        return new ToneWrapper(this, source){

            public double getSample(double offTime, double begTime, double endTime) {
                double result = 0.0;
                int i = 0;
                while (i < Harmony.this.gains.length) {
                    double mult = i + 1;
                    double value = this.source.getSample(offTime * mult, begTime * mult, endTime * mult);
                    result += value * Harmony.this.gains[i];
                    ++i;
                }
                return result * Harmony.this.correction;
            }
        };
    }
}

