/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.music.effect;

import org.corebounce.decklight.bouncelets.music.Tone;
import org.corebounce.decklight.bouncelets.music.effect.ToneEffect;
import org.corebounce.decklight.bouncelets.music.effect.ToneWrapper;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;

public class PhaseShift
extends ToneEffect {
    public InDouble inShift = new InDouble("shift", "Phase shift [\u03c0]", 1.0, 0.0, 2.0);
    private double shift;

    public PhaseShift() {
        super("music.effect.phaseshift", "Shift the phase of the tone");
        this.inShift.setSkillType(SkillType.SIMPLIFIED);
    }

    protected boolean isModified() {
        return this.inShift.isModified();
    }

    protected void updateParameters() {
        this.shift = (Double)this.inShift.read();
    }

    protected Tone createTranform(Tone source) {
        return new ToneWrapper(this, source){
            private double lastChangeTime;
            private double period;
            {
                this.lastChangeTime = -1.0;
                this.period = 0.0;
            }

            public double getSample(double offTime, double begTime, double endTime) {
                if (this.lastChangeTime < this.source.getLastChangeTime()) {
                    this.lastChangeTime = this.source.getLastChangeTime();
                    this.period = this.source.getPeriod();
                }
                double offset = this.period * PhaseShift.this.shift / 2.0;
                if (offTime >= 0.0) {
                    offTime += offset;
                }
                return this.source.getSample(offTime, begTime + offset, endTime + offset);
            }
        };
    }
}

